/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.PointSymbol;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.XYChart;

public class ScatterChart
extends XYChart {
    private PointSymbol pointSymbol;

    public ScatterChart() {
        this((AbstractDataProvider<?>)null, (AbstractDataProvider<?>)null);
    }

    public ScatterChart(AbstractDataProvider<?> xData, AbstractDataProvider<?> yData) {
        super(ChartType.Scatter, xData, yData);
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.coordinateSystem == null || !RectangularCoordinate.class.isAssignableFrom(this.coordinateSystem.getClass())) {
            throw new ChartException("Scatter chart must be plotted on a rectangular coordinate system");
        }
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.pointSymbol != null) {
            this.pointSymbol.encodeJSON(sb);
        }
    }

    public PointSymbol getPointSymbol(boolean create) {
        if (this.pointSymbol == null && create) {
            this.pointSymbol = new PointSymbol();
        }
        return this.pointSymbol;
    }

    public void setPointSymbol(PointSymbol pointSymbol) {
        this.pointSymbol = pointSymbol;
    }
}

