/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractDataZoom;
import com.storedobject.chart.AngleAxis;
import com.storedobject.chart.Axis;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Color;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentGroup;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.Event;
import com.storedobject.chart.EventCategory;
import com.storedobject.chart.EventListener;
import com.storedobject.chart.EventType;
import com.storedobject.chart.HasData;
import com.storedobject.chart.InternalDataProvider;
import com.storedobject.chart.Language;
import com.storedobject.chart.Legend;
import com.storedobject.chart.PolarCoordinate;
import com.storedobject.chart.RadarCoordinate;
import com.storedobject.chart.RadiusAxis;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.Shape;
import com.storedobject.chart.TextStyle;
import com.storedobject.chart.Title;
import com.storedobject.chart.Toolbox;
import com.storedobject.chart.Tooltip;
import com.storedobject.chart.VisualMap;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.YAxis;
import com.storedobject.helper.ID;
import com.storedobject.helper.LitComponentWithSize;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@NpmPackage(value="echarts", version="6.0.0")
@Tag(value="so-chart")
@JsModule(value="./chart.js")
public class SOChart
extends LitComponentWithSize {
    static final ComponentEncoder[] encoders = new ComponentEncoder[]{new ComponentEncoder("*", DefaultColors.class), new ComponentEncoder("*", DefaultTextStyle.class), new ComponentEncoder(Title.class), new ComponentEncoder(Legend.class), new ComponentEncoder(Tooltip.class), new ComponentEncoder("angleAxis", AngleAxis.AngleAxisWrapper.class), new ComponentEncoder("radiusAxis", RadiusAxis.RadiusAxisWrapper.class), new ComponentEncoder("xAxis", XAxis.XAxisWrapper.class), new ComponentEncoder("yAxis", YAxis.YAxisWrapper.class), new ComponentEncoder("polar", PolarCoordinate.class), new ComponentEncoder("radar", RadarCoordinate.class), new ComponentEncoder("grid", RectangularCoordinate.class), new ComponentEncoder("series", Chart.class), new ComponentEncoder("dataZoom", AbstractDataZoom.class), new ComponentEncoder("visualMap", VisualMap.class), new ComponentEncoder("graphic", Shape.class), new ComponentEncoder(Toolbox.class)};
    private final List<ComponentGroup> componentGroups = new ArrayList<ComponentGroup>();
    private final List<Component> components = new ArrayList<Component>();
    private final List<ComponentPart> parts = new ArrayList<ComponentPart>();
    private final List<AbstractDataProvider<?>> dataSet = new ArrayList();
    private final List<AbstractDataProvider<?>> extraData = new ArrayList();
    private Legend legend = new Legend();
    private Tooltip tooltip = new Tooltip();
    private boolean neverUpdated = true;
    private DefaultColors defaultColors;
    private AbstractColor defaultBackground;
    private DefaultTextStyle defaultTextStyle;
    private String theme;
    private Language language;
    private boolean svg = false;
    private final Map<Integer, Integer> dataLengthMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> datasetIndexMap = new HashMap<Integer, Integer>();
    private boolean debugData = false;
    private boolean debugOptions = false;
    private boolean debugEvents = false;
    private final AtomicInteger eventId = new AtomicInteger(0);
    private final EventHandles eventHandles = new EventHandles();

    public SOChart() {
        this.getElement().setProperty("idChart", "sochart" + ID.newID());
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        try {
            if (this.neverUpdated) {
                this.update();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends ComponentPart> partType(String type) {
        for (ComponentEncoder ce : encoders) {
            if (!ce.label.equals(type)) continue;
            return ce.partType;
        }
        return null;
    }

    public void debug(boolean debugData, boolean debugOptions, boolean debugEvents) {
        this.debugData = debugData;
        this.debugOptions = debugOptions;
        this.debugEvents = debugEvents;
        if (!this.neverUpdated) {
            this.executeJS("debug", new Object[]{debugData, debugOptions, debugEvents});
        }
    }

    @ClientCallable
    public void onError(String message) {
        Notification.show((String)message, (int)60000, (Notification.Position)Notification.Position.MIDDLE, (boolean)true);
    }

    @ClientCallable
    private void onMouseEvent(int id, String componentType, int componentIndex, String componentSubtype, String seriesId, String seriesName, String targetType, String value, String dataType, String seriesType, String color) {
        EventHandler eventHandler = (EventHandler)this.eventHandles.get(id);
        if (eventHandler == null) {
            return;
        }
        Event event = new Event(this, eventHandler.type, eventHandler.userData);
        if (componentType != null && !componentType.isEmpty()) {
            event.addData("typeName", componentType.equals("series") ? "chart" : componentType);
            event.addData("type", SOChart.partType(componentType));
        }
        event.addData("serial", componentIndex);
        String part = componentSubtype;
        if (part == null || part.isEmpty()) {
            part = targetType;
        }
        event.addData("part", part);
        event.addData("value", value);
        if (seriesId != null && !seriesId.isEmpty()) {
            event.addData("chartId", seriesId);
        }
        if (seriesName != null && !seriesName.isEmpty()) {
            event.addData("chartName", seriesName);
        }
        if (dataType != null && !dataType.isEmpty()) {
            event.addData("dataType", dataType);
        }
        if (seriesType != null && !seriesType.isEmpty()) {
            event.addData("chartType", seriesType);
        }
        if (color != null && !color.isEmpty()) {
            event.addData("color", color);
        }
        eventHandler.listener.onEvent(event);
    }

    @ClientCallable
    private void onLegendEvent(int id, String legendName, String legendSelection) {
        EventHandler eventHandler = (EventHandler)this.eventHandles.get(id);
        if (eventHandler == null) {
            return;
        }
        Event event = new Event(this, eventHandler.type, eventHandler.userData);
        event.addData("legendName", legendName);
        event.addData("legendSelection", legendSelection);
        eventHandler.listener.onEvent(event);
    }

    public void dispatchAction(String parameters) {
        this.executeJS("dispatchAction", new Object[]{parameters});
    }

    public void setVisible(boolean visible, Chart chart) {
        this.dispatchAction("{\"type\":\"legend" + (visible ? "" : "Un") + "Select\",\"name\":\"" + chart.getName() + "\"}");
    }

    public void toggleVisible(Chart chart) {
        this.dispatchAction("{\"type\":\"legendToggleSelect\",\"name\":\"" + chart.getName() + "\"}");
    }

    public Registration addListener(EventType eventType, EventListener listener, Chart chart) {
        return this.addListener(eventType, listener, chart, -1, null);
    }

    public Registration addListener(EventType eventType, EventListener listener, Chart chart, String dataType) {
        return this.addListener(eventType, listener, chart, -1, dataType);
    }

    public Registration addListener(EventType eventType, EventListener listener, Chart chart, int dataIndex) {
        return this.addListener(eventType, listener, chart, dataIndex, null);
    }

    public Registration addListener(EventType eventType, EventListener listener, Chart chart, int dataIndex, String dataType) {
        StringBuilder p = new StringBuilder();
        if (chart != null) {
            p.append("{\"seriesId\":\"").append(chart.getId()).append('\"');
            if (dataIndex >= 0) {
                p.append(",\"dataIndex\":").append(dataIndex);
            }
            if (dataType != null && !dataType.isEmpty()) {
                p.append(",\"dataType\":\"").append(dataType).append("\"");
            }
            p.append("}");
        }
        return this.addListener(eventType, listener, p.isEmpty() ? null : p.toString(), chart);
    }

    public Registration addListener(EventType eventType, EventListener listener) {
        return this.addListener(eventType, listener, (String)null, null);
    }

    public Registration addListener(EventType eventType, EventListener listener, Object userData) {
        return this.addListener(eventType, listener, null, userData);
    }

    public Registration addListener(EventType eventType, EventListener listener, String parameters) {
        return this.addListener(eventType, listener, parameters, null);
    }

    public Registration addListener(EventType eventType, EventListener listener, String parameters, Object userData) {
        EventHandler eh = new EventHandler(this, listener, eventType, parameters, userData);
        return (Registration & Serializable)() -> this.eventHandles.removeHandler(eh);
    }

    public List<AbstractColor> getDefaultColors() {
        if (this.defaultColors == null) {
            this.defaultColors = new DefaultColors();
        }
        return this.defaultColors;
    }

    public void setDefaultBackground(Color background) {
        this.defaultBackground = background;
    }

    public TextStyle getDefaultTextStyle() {
        if (this.defaultTextStyle == null) {
            this.defaultTextStyle = new DefaultTextStyle();
        }
        return this.defaultTextStyle.textStyle;
    }

    public void disableDefaultTooltip() {
        this.tooltip = null;
    }

    public void enableDefaultTooltip() {
        if (this.tooltip == null) {
            this.tooltip = new Tooltip();
        }
    }

    public Tooltip getDefaultTooltip() {
        return this.tooltip;
    }

    public void disableDefaultLegend() {
        this.legend = null;
    }

    public void enableDefaultLegend() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
    }

    public Legend getDefaultLegend() {
        return this.legend;
    }

    public void setDarkTheme() {
        this.theme = "dark";
        this.updateThemeAndLocale();
    }

    public void setSVGRendering() {
        this.svg = true;
        this.updateThemeAndLocale();
    }

    public void setLanguage(Language language) {
        this.language = language;
        this.updateThemeAndLocale();
    }

    private void updateThemeAndLocale() {
        if (!this.neverUpdated) {
            this.executeJS("setThemeAndLocale", new Object[]{this.theme, this.language(), this.svg ? "svg" : "canvas"});
        }
    }

    private String language() {
        if (this.language == null) {
            return null;
        }
        return this.language.toString().replace('_', '-');
    }

    void addParts(ComponentPart ... parts) {
        if (parts != null) {
            for (ComponentPart cp : parts) {
                if (cp == null) continue;
                this.parts.add(cp);
            }
        }
    }

    public void addData(AbstractDataProvider<?> data) {
        if (data != null && !this.extraData.contains(data)) {
            this.extraData.add(data);
        }
    }

    public void removeData(AbstractDataProvider<?> data) {
        this.extraData.remove(data);
    }

    List<AbstractDataProvider<?>> dataSet() {
        return this.dataSet;
    }

    public void add(ComponentGroup ... componentGroups) {
        if (componentGroups != null) {
            for (ComponentGroup componentGroup : componentGroups) {
                if (componentGroup == null) continue;
                this.componentGroups.add(componentGroup);
            }
        }
    }

    public void remove(ComponentGroup ... componentGroups) {
        if (componentGroups != null) {
            for (ComponentGroup componentGroup : componentGroups) {
                if (componentGroup == null) continue;
                this.componentGroups.remove(componentGroup);
                componentGroup.removeParts(this);
            }
        }
    }

    public void add(Component ... components) {
        if (components != null) {
            for (Component c : components) {
                if (c == null) continue;
                this.components.add(c);
            }
        }
    }

    public void remove(Component ... components) {
        if (components != null) {
            for (Component c : components) {
                if (c == null) continue;
                this.components.remove(c);
            }
        }
    }

    public void removeAll() {
        this.eventHandles.clear();
        this.componentGroups.clear();
        this.components.clear();
        this.dataSet.clear();
        this.datasetIndexMap.clear();
        this.dataLengthMap.clear();
    }

    public void clear() {
        if (this.neverUpdated) {
            return;
        }
        this.executeJS("clearChart", new Object[0]);
    }

    public void update() throws ChartException, Exception {
        this.update(true);
    }

    public void update(boolean skipData) throws ChartException, Exception {
        if (this.neverUpdated && skipData) {
            skipData = false;
        }
        if (!skipData) {
            this.executeJS("clearData", new Object[0]);
        }
        for (ComponentGroup cg : this.componentGroups) {
            cg.validate();
            cg.addParts(this);
        }
        if (this.components.isEmpty()) {
            this.clear();
            return;
        }
        for (Component component : this.components) {
            component.validate();
        }
        this.components.forEach(c -> c.setSerial(-2));
        this.parts.clear();
        this.components.forEach(c -> c.addParts(this));
        ArrayList data = new ArrayList();
        this.dataSet.clear();
        this.parts.stream().filter(p -> p instanceof AbstractDataProvider).map(p -> (AbstractDataProvider)p).forEach(data::add);
        this.parts.removeIf(p -> p instanceof AbstractDataProvider);
        HashSet<AbstractDataProvider> collectData = new HashSet<AbstractDataProvider>();
        this.parts.stream().filter(p -> p instanceof HasData).map(p -> (HasData)((Object)p)).forEach(p -> p.declareData(collectData));
        collectData.removeIf(Objects::isNull);
        data.addAll(collectData);
        int dserial = data.stream().mapToInt(ComponentPart::getSerial).max().orElse(1);
        dserial = Math.max(dserial, 1);
        while (!data.isEmpty()) {
            AbstractDataProvider d = (AbstractDataProvider)data.removeFirst();
            if (!(d instanceof InternalDataProvider)) {
                this.dataSet.add(d);
            }
            dserial = this.getDataSerial(skipData, dserial, d);
            data.removeIf(ad -> ad.getSerial() == d.getSerial());
            this.extraData.removeIf(ad -> ad.getSerial() == d.getSerial());
        }
        for (AbstractDataProvider abstractDataProvider : this.extraData) {
            this.dataSet.add(abstractDataProvider);
            dserial = this.getDataSerial(skipData, dserial, abstractDataProvider);
        }
        for (ComponentPart componentPart : this.parts) {
            componentPart.setSerial(-2);
        }
        this.parts.addAll(this.components);
        if (this.defaultColors != null && !this.defaultColors.isEmpty()) {
            this.parts.add(this.defaultColors);
        }
        if (this.defaultTextStyle != null) {
            this.parts.add(this.defaultTextStyle);
        }
        if (this.legend != null && this.parts.stream().noneMatch(cp -> cp instanceof Legend)) {
            this.parts.add(this.legend);
        }
        if (this.tooltip != null && this.parts.stream().noneMatch(cp -> cp instanceof Tooltip)) {
            this.parts.add(this.tooltip);
        }
        for (ComponentEncoder ce : encoders) {
            int n = 0;
            for (ComponentPart cp2 : this.parts) {
                if (!ce.partType.isAssignableFrom(cp2.getClass())) continue;
                if (cp2.getSerial() == -2) {
                    cp2.setSerial(n++);
                    continue;
                }
                if (cp2.getSerial() >= 0) continue;
                throw new ChartException("Get/set serial not properly implemented in " + cp2.className());
            }
        }
        for (Component component : this.components) {
            component.validate();
        }
        for (ComponentPart componentPart : this.parts) {
            componentPart.validate();
        }
        this.parts.sort(Comparator.comparing(ComponentPart::getSerial));
        StringBuilder sb = new StringBuilder();
        sb.append("{\"dataset\":[");
        ArrayList<ArrayList<Integer>> arrayList = new ArrayList<ArrayList<Integer>>();
        for (AbstractDataProvider<?> d : this.dataSet) {
            int n = this.dataLengthMap.get(d.getSerial());
            ArrayList<Integer> order = arrayList.stream().filter(o -> (Integer)o.getFirst() == length).findFirst().orElse(null);
            if (order == null) {
                order = new ArrayList<Integer>();
                order.add(n);
                arrayList.add(order);
            }
            order.add(d.getSerial());
        }
        boolean firstIndex = true;
        for (List list : arrayList) {
            if (firstIndex) {
                firstIndex = false;
            } else {
                sb.append(',');
            }
            sb.append("{\"source\":{");
            sb.append(list.stream().skip(1L).map(i -> "\"d" + i + "\":" + i).collect(Collectors.joining(",")));
            sb.append("}}");
        }
        sb.append("]");
        if (this.defaultBackground != null) {
            sb.append(",\"backgroundColor\":").append(this.defaultBackground);
        }
        for (ComponentEncoder ce : encoders) {
            ce.encode(this, sb, this.parts);
        }
        ComponentPart.addComma(sb);
        this.addCustomEncoding((ComponentPart)null, sb);
        ComponentPart.removeComma(sb);
        sb.append('}');
        this.executeJS("updateChart", new Object[]{!skipData, this.customizeJSON(sb.toString()), this.theme, this.language(), this.svg ? "svg" : "canvas", this.debugData, this.debugOptions, this.debugEvents});
    }

    private void chartUpdated() {
        this.dataSet.clear();
        this.parts.clear();
        this.defaultColors = null;
        this.defaultBackground = null;
        this.defaultTextStyle = null;
        this.neverUpdated = false;
    }

    private int getDataSerial(boolean skipData, int dserial, AbstractDataProvider<?> d) throws Exception {
        if (skipData) {
            if (d.getSerial() <= 0) {
                d.validate();
                d.setSerial(dserial++);
                this.initData(d);
            }
        } else {
            if (d.getSerial() <= 0) {
                d.validate();
                d.setSerial(dserial++);
            }
            this.initData(d);
        }
        return dserial;
    }

    protected void addCustomEncoding(Class<? extends ComponentPart> componentPartClass, StringBuilder buffer) {
    }

    protected void addCustomEncoding(ComponentPart componentPart, StringBuilder buffer) {
    }

    protected String customizeJSON(String json) throws Exception {
        return json;
    }

    protected String customizeDataJSON(String json, AbstractDataProvider<?> data) throws Exception {
        return json;
    }

    private void initData(AbstractDataProvider<?> data) throws Exception {
        this.updateData("init", data);
    }

    private void updateData(String command, AbstractDataProvider<?> data) throws Exception {
        StringBuilder b = new StringBuilder();
        data.encodeJSON(b);
        String d = this.customizeDataJSON(b.toString(), data);
        int count = SOChart.countData(d);
        if (count < 0) {
            throw new ChartException("Invalid data from " + data.className() + ": " + d);
        }
        Integer oldCount = this.dataLengthMap.get(data.getSerial());
        this.dataLengthMap.put(data.getSerial(), count);
        if (oldCount != null && count != oldCount) {
            Integer oldIndex = this.datasetIndexMap.get(oldCount);
            this.datasetIndexMap.put(count, oldIndex);
        }
        this.executeJS(command + "Data", new Object[]{data.getSerial(), "{\"d\":" + d + "}", this.datasetIndex(data)});
    }

    private int datasetIndex(AbstractDataProvider<?> data) {
        int count = this.dataLengthMap.getOrDefault(data.getSerial(), 0);
        return this.datasetIndexMap.computeIfAbsent(count, k -> this.datasetIndexMap.size());
    }

    private static int countData(String d) {
        int i = d.indexOf(91);
        d = d.substring(i + 1);
        i = d.lastIndexOf(93);
        d = d.substring(0, i);
        int depth = 0;
        int count = 1;
        boolean inQuote = false;
        char quoteChar = '\u0000';
        for (i = 0; i < d.length(); ++i) {
            char c = d.charAt(i);
            if (!inQuote) {
                if (c == '[' || c == '{' || c == '(') {
                    ++depth;
                } else if (c == ']' || c == '}' || c == ')') {
                    --depth;
                } else if (c == '\'' || c == '\"') {
                    inQuote = true;
                    quoteChar = c;
                } else if (depth == 0 && c == ',') {
                    ++count;
                }
            } else if (c == quoteChar && d.charAt(i - 1) != '\\') {
                inQuote = false;
            }
            if (depth >= 0) continue;
            return -1;
        }
        if (depth != 0) {
            return -1;
        }
        return count;
    }

    public void updateData(AbstractDataProvider<?> ... data) throws Exception {
        if (data != null) {
            for (AbstractDataProvider<?> d : data) {
                if (d == null || d.getSerial() <= 0) continue;
                this.updateData("update", d);
            }
        }
    }

    public void updateData(HasData ... dataOwners) throws Exception {
        if (dataOwners != null) {
            HashSet dataSet = new HashSet();
            for (HasData hd : dataOwners) {
                if (hd == null) continue;
                hd.declareData(dataSet);
            }
            for (AbstractDataProvider abstractDataProvider : dataSet) {
                if (abstractDataProvider == null || abstractDataProvider.getSerial() <= 0) continue;
                this.updateData("update", abstractDataProvider);
            }
        }
    }

    void updateData(String data, String command) {
        if (this.neverUpdated) {
            return;
        }
        this.executeJS(command + "Data", new Object[]{data});
    }

    public static Color getDefaultColor(int index) {
        return new Color(DefaultColors.colors[index % DefaultColors.colors.length]);
    }

    @ClientCallable
    private void sendEvents(int id) {
        if (id == 0) {
            id = Integer.MIN_VALUE;
        }
        this.eventHandles.send(id);
    }

    private class EventHandles
    extends ConcurrentHashMap<Integer, EventHandler> {
        private EventHandles() {
        }

        public void removeHandler(EventHandler eventHandler) {
            if (this.remove(eventHandler.id) != null && !SOChart.this.neverUpdated) {
                SOChart.this.executeJS("undefineSOEvent", new Object[]{eventHandler.id});
            }
        }

        void send(int id) {
            int minId = SOChart.this.eventHandles.keySet().stream().mapToInt(k -> k).filter(k -> k > id).min().orElse(Integer.MAX_VALUE);
            if (minId == Integer.MAX_VALUE) {
                SOChart.this.chartUpdated();
                return;
            }
            EventHandler eh = (EventHandler)SOChart.this.eventHandles.get(minId);
            SOChart.this.executeJS("defineSOEvent", new Object[]{eh.id, eh.type.getName(), eh.type.getCategory().ordinal(), eh.parameters});
        }
    }

    static class ComponentEncoder {
        final String label;
        final Class<? extends ComponentPart> partType;

        private ComponentEncoder(Class<? extends ComponentPart> partType) {
            this(null, partType);
        }

        private ComponentEncoder(String label, Class<? extends ComponentPart> partType) {
            this.partType = partType;
            if (label == null) {
                label = partType.getName();
                label = ((String)label).substring(((String)label).lastIndexOf(46) + 1);
                label = Character.toLowerCase(((String)label).charAt(0)) + ((String)label).substring(1);
            }
            this.label = label;
        }

        private Class<? extends ComponentPart> partClass() {
            if (!Axis.AxisWrapper.class.isAssignableFrom(this.partType)) {
                return this.partType;
            }
            if (XAxis.XAxisWrapper.class.isAssignableFrom(this.partType)) {
                return XAxis.class;
            }
            if (YAxis.YAxisWrapper.class.isAssignableFrom(this.partType)) {
                return YAxis.class;
            }
            if (AngleAxis.AngleAxisWrapper.class.isAssignableFrom(this.partType)) {
                return AngleAxis.class;
            }
            if (RadiusAxis.RadiusAxisWrapper.class.isAssignableFrom(this.partType)) {
                return RadiusAxis.class;
            }
            return this.partType;
        }

        private void encode(SOChart soChart, StringBuilder sb, List<? extends ComponentPart> components) {
            int renderingIndex = 0;
            int serial = -2;
            for (ComponentPart componentPart : components) {
                Chart chart;
                AbstractDataProvider<?> mainData;
                if (!this.partType.isAssignableFrom(componentPart.getClass())) continue;
                if (componentPart.getSerial() < serial) break;
                if (componentPart.getSerial() == serial) continue;
                componentPart.setRenderingIndex(renderingIndex);
                serial = componentPart.getSerial();
                if (renderingIndex == 0) {
                    if (sb.length() > 1) {
                        sb.append(",\n");
                    }
                    if ("*".equals(this.label)) {
                        ++renderingIndex;
                        componentPart.encodeJSON(sb);
                        return;
                    }
                    sb.append('\"').append(this.label).append("\":");
                    sb.append('[');
                } else {
                    sb.append(',');
                }
                ++renderingIndex;
                sb.append('{');
                componentPart.encodeJSON(sb);
                ComponentPart.addComma(sb);
                soChart.addCustomEncoding(componentPart, sb);
                ComponentPart.removeComma(sb);
                if (componentPart instanceof Chart && (mainData = (chart = (Chart)componentPart).mainData()) != null) {
                    ComponentPart.addComma(sb);
                    sb.append("\"datasetIndex\":").append(soChart.datasetIndex(mainData));
                }
                sb.append('}');
            }
            ComponentPart.addComma(sb);
            if (renderingIndex > 0) {
                soChart.addCustomEncoding(this.partClass(), sb);
            } else {
                int start = sb.length();
                sb.append('\"').append(this.label).append("\":");
                sb.append('[');
                int n = sb.length();
                soChart.addCustomEncoding(this.partClass(), sb);
                if (sb.length() == n) {
                    sb.delete(start, n);
                    ComponentPart.removeComma(sb);
                    return;
                }
            }
            ComponentPart.removeComma(sb);
            sb.append(']');
        }
    }

    private final class EventHandler {
        private final int id;
        private final EventListener listener;
        private final EventType type;
        private final Object userData;
        private final String parameters;

        private EventHandler(SOChart sOChart, EventListener listener, EventType type, String parameters, Object userData) {
            if (type == null) {
                type = EventType.BlankAreaClick;
            }
            int i = sOChart.eventId.incrementAndGet();
            if (parameters == null || parameters.isEmpty() || type.getCategory() == EventCategory.BlankArea) {
                parameters = "";
            }
            this.id = i;
            this.listener = listener;
            this.type = type;
            this.parameters = parameters;
            this.userData = userData;
            sOChart.eventHandles.put(this.id, this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof EventHandler)) return false;
            EventHandler eh = (EventHandler)obj;
            if (eh.id != this.id) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class DefaultColors
    extends ArrayList<AbstractColor>
    implements ComponentPart {
        private static final String[] colors = new String[]{"0000ff", "c23531", "2f4554", "61a0a8", "d48265", "91c7ae", "749f83", "ca8622", "bda29a", "6e7074", "546570", "c4ccd3"};
        private int serial;

        private DefaultColors() {
        }

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public void validate() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append("\"color\":[");
            int count = 0;
            boolean first = true;
            for (AbstractColor c : this) {
                if (c == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(c);
                ++count;
            }
            int i = 0;
            while (count < 11) {
                Color c = new Color(colors[i]);
                if (!this.contains(c)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(c);
                    ++count;
                }
                ++i;
            }
            sb.append(']');
        }

        @Override
        public final int getSerial() {
            return this.serial;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }
    }

    private static class DefaultTextStyle
    implements ComponentPart {
        private int serial;
        private final TextStyle textStyle = new TextStyle();

        private DefaultTextStyle() {
        }

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public void validate() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            TextStyle.OuterProperties op = new TextStyle.OuterProperties();
            this.textStyle.save(op);
            sb.append("\"textStyle\":{");
            ComponentPart.encode(sb, null, this.textStyle);
            sb.append('}');
        }

        @Override
        public final int getSerial() {
            return this.serial;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }
    }
}

