/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AngleAxis;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.PolarProperty;
import com.storedobject.chart.RadiusAxis;

public class PolarCoordinate
extends CoordinateSystem
implements HasPolarProperty {
    private PolarProperty polarProperty;

    public PolarCoordinate() {
    }

    public PolarCoordinate(RadiusAxis radiusAxis, AngleAxis angleAxis) {
        this.addAxis(radiusAxis, angleAxis);
    }

    @Override
    public void validate() throws ChartException {
        if (this.noAxis(RadiusAxis.class)) {
            throw new ChartException("Radius Axis is not set");
        }
        if (this.noAxis(AngleAxis.class)) {
            throw new ChartException("Angle Axis is not set");
        }
    }

    @Override
    public final PolarProperty getPolarProperty(boolean create) {
        if (this.polarProperty == null && create) {
            this.polarProperty = new PolarProperty();
        }
        return this.polarProperty;
    }

    @Override
    public final void setPolarProperty(PolarProperty polarProperty) {
        this.polarProperty = polarProperty;
    }

    @Override
    String systemName() {
        return "polar";
    }

    @Override
    String[] axesData() {
        return new String[]{"radius", "angle"};
    }
}

