/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.Offset;
import com.storedobject.chart.PointSymbolType;
import com.storedobject.chart.VisibleProperty;

public class PointSymbol
implements ComponentProperty,
VisibleProperty {
    private PointSymbolType type;
    private boolean show = true;
    String size;
    private boolean hoverAnimation = true;
    private String url = null;
    private Offset offset;

    public PointSymbol() {
        this(PointSymbolType.CIRCLE);
    }

    public PointSymbol(PointSymbolType type) {
        this.type = type;
    }

    public void setURL(String url) {
        if (url == null || url.isEmpty()) {
            this.url = null;
            return;
        }
        this.url = url.startsWith("image://") || url.startsWith("path://") ? url : null;
    }

    @Override
    public void setVisible(boolean visible) {
        this.show = visible;
    }

    @Override
    public boolean isVisible() {
        return this.show;
    }

    public void setType(PointSymbolType pointSymbolType) {
        this.type = pointSymbolType;
    }

    public final PointSymbolType getType() {
        return this.type;
    }

    public void setSize(int size) {
        this.size = size <= 0 ? null : "" + size;
    }

    public PointSymbol size(int size) {
        this.setSize(size);
        return this;
    }

    public void setSize(int width, int height) {
        if (width > 0 && height > 0) {
            this.size = "[" + width + "," + height + "]";
        } else if (width > 0) {
            this.setSize(width);
        } else if (height > 0) {
            this.setSize(height);
        } else {
            this.size = null;
        }
    }

    public PointSymbol size(int width, int height) {
        this.setSize(width, height);
        return this;
    }

    public void setHoverAnimation(boolean hoverAnimation) {
        this.hoverAnimation = hoverAnimation;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public PointSymbol offset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public Offset getOffset(boolean createIfNotExists) {
        if (this.offset == null && createIfNotExists) {
            this.offset = new Offset();
        }
        return this.offset;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        String t = this.url == null ? this.type.toString() : this.url;
        ComponentPart.encode(sb, "symbol", t);
        if (this.size != null) {
            sb.append(",\"symbolSize\":").append(this.size);
        }
        ComponentPart.encode(sb, "hoverAnimation", this.hoverAnimation);
        ComponentPart.encode(sb, "showSymbol", this.show);
        Offset o = this.getOffset(false);
        if (o != null) {
            o.encodeJSON("symbolOffset", sb);
        }
    }
}

