/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.util.Comparator;
import java.util.Date;

public interface DateDataProvider
extends AbstractDataProvider<LocalDate> {
    @Override
    default public DataType getDataType() {
        return DataType.DATE;
    }

    public boolean add(LocalDate var1);

    default public boolean add(Date date) {
        if (date == null) {
            return false;
        }
        return this.add(date.getTime());
    }

    default public boolean add(long timeInMillis) {
        long nanos = (timeInMillis - timeInMillis / 1000L * 1000L) * 1000L;
        return this.add(LocalDateTime.ofEpochSecond(timeInMillis / 1000L, (int)nanos, ZoneOffset.UTC).toLocalDate());
    }

    @Override
    default public Comparator<LocalDate> getComparator() {
        return (d1, d2) -> {
            if (d1 == null || d2 == null) {
                return d1 == null && d2 == null ? 0 : (d1 == null ? -1 : 1);
            }
            return d1.isBefore((ChronoLocalDate)d2) ? -1 : (d1.isAfter((ChronoLocalDate)d2) ? 1 : 0);
        };
    }
}

