/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.Color;
import java.util.ArrayList;
import java.util.List;

public class ColorGradient
extends AbstractColor {
    private final List<Color> colors = new ArrayList<Color>();
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 100;

    public ColorGradient(Color ... colors) {
        this.setColors(colors);
    }

    public final List<Color> getColors() {
        return this.colors;
    }

    public void setColors(Color ... colors) {
        this.colors.clear();
        if (colors != null) {
            for (Color c : colors) {
                if (c == null) continue;
                this.colors.add(c);
            }
        }
    }

    public void setGradient(int x1, int y1, int x2, int y2) {
        this.x1 = ColorGradient.mm(x1);
        this.x2 = ColorGradient.mm(x2);
        this.y1 = ColorGradient.mm(y1);
        this.y2 = ColorGradient.mm(y2);
    }

    public void setGradient(int x, int y, int r) {
        this.x1 = ColorGradient.mm(x);
        this.x2 = ColorGradient.mm(r);
        this.y1 = ColorGradient.mm(y);
        this.y2 = Integer.MAX_VALUE;
    }

    private static int mm(int v) {
        return Math.max(0, Math.min(100, v));
    }

    public String toString() {
        if (this.colors.isEmpty()) {
            return Color.TRANSPARENT.toString();
        }
        if (this.colors.size() == 1) {
            return this.colors.get(0).toString();
        }
        StringBuilder sb = new StringBuilder("{\"type\":\"");
        sb.append(this.y2 == Integer.MAX_VALUE ? "radial" : "linear").append("\",\"x\":");
        sb.append((double)this.x1 / 100.0).append(",\"y\":").append((double)this.y1 / 100.0).append(",\"");
        if (this.y2 == Integer.MAX_VALUE) {
            sb.append("r\":").append((double)this.x2 / 100.0);
        } else {
            sb.append("x2\":").append((double)this.x2 / 100.0).append(",\"y2\":").append((double)this.y2 / 100.0);
        }
        sb.append(",\"colorStops\":[");
        double slice = 100.0 / (double)(this.colors.size() - 1);
        for (int i = 0; i < this.colors.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append("{\"offset\":");
            if (i == 0) {
                sb.append('0');
            } else if (i == this.colors.size() - 1) {
                sb.append('1');
            } else {
                sb.append((double)i * slice / 100.0);
            }
            sb.append(",\"color\":").append(this.colors.get(i)).append('}');
        }
        sb.append("]}");
        return sb.toString();
    }
}

