/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.BoxplotData;
import com.storedobject.chart.CategoryData;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataType;
import com.storedobject.chart.XYChart;

public class BoxplotChart
extends XYChart {
    private boolean horizontal = true;
    private final AbstractDataProvider<?> category;
    private final AbstractDataProvider<BoxplotData.Boxplot> data;

    public BoxplotChart(CategoryData xData, AbstractDataProvider<BoxplotData.Boxplot> yData) {
        super(ChartType.Boxplot, (AbstractDataProvider<?>)xData, (AbstractDataProvider<?>)yData);
        this.category = xData;
        this.data = yData;
    }

    public BoxplotChart(AbstractDataProvider<BoxplotData.Boxplot> xData, CategoryData yData) {
        super(ChartType.Boxplot, (AbstractDataProvider<?>)xData, (AbstractDataProvider<?>)yData);
        this.horizontal = false;
        this.category = yData;
        this.data = xData;
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.data;
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        Axis axis = this.getCoordinateSystem().getAxis(this.horizontal ? 0 : 1);
        if (axis.getDataType() != DataType.CATEGORY) {
            throw new ChartException((this.horizontal ? "X" : "Y") + "-axis must be a category axis");
        }
        axis.setData(this.category);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.encode(sb, "layout", this.horizontal ? "horizontal" : "vertical");
    }
}

