/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.TextBorder;
import java.util.Arrays;

public class Border
extends TextBorder {
    private AbstractColor background;
    private final int[] radius = new int[4];

    public Border() {
        Arrays.fill(this.radius, 0);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        if (this.any()) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(this.p("borderRadius")).append("\":");
            if (this.radius[0] == this.radius[1] && this.radius[1] == this.radius[2] && this.radius[2] == this.radius[3]) {
                sb.append(this.radius[0]);
            } else {
                for (int i = 0; i < this.radius.length; ++i) {
                    if (i == 0) {
                        sb.append('[');
                    } else {
                        sb.append(',');
                    }
                    sb.append(this.radius[i]);
                }
                sb.append(']');
            }
        }
        if (this.background != null) {
            ComponentPart.addComma(sb);
            sb.append("\"backgroundColor\":").append(this.background);
        }
        super.encodeJSON(sb);
    }

    private boolean any() {
        for (int r : this.radius) {
            if (r <= 0) continue;
            return true;
        }
        return false;
    }

    public final AbstractColor getBackground() {
        return this.background;
    }

    public void setBackground(AbstractColor background) {
        this.background = background;
    }

    public void setRadius(int radius) {
        Arrays.fill(this.radius, Math.min(90, Math.max(0, radius)));
    }

    public void setRadius(int index, int radius) {
        if (index >= 0) {
            this.radius[index % this.radius.length] = Math.min(90, Math.max(0, radius));
        }
    }
}

