/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractLabel;
import com.storedobject.chart.AbstractPart;
import com.storedobject.chart.Area;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.DataType;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.Location;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.Shadow;
import com.storedobject.chart.TextStyle;
import com.storedobject.chart.VisiblePart;
import com.storedobject.chart.Wrapped;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class Axis
extends VisiblePart
implements Wrapped {
    private DataType dataType;
    Map<CoordinateSystem, AxisWrapper> wrappers = new HashMap<CoordinateSystem, AxisWrapper>();
    private String name;
    private int nameGap = 15;
    private int nameRotation = 0;
    private Location nameLocation;
    private TextStyle nameTextStyle;
    private boolean inverted = false;
    private Object min;
    private Object max;
    private int divisions = 0;
    private boolean showZero = true;
    private Label label;
    private MinorTicks minorTicks;
    private Ticks ticks;
    private GridLines gridLines;
    private MinorGridLines minorGridLines;
    private GridAreas gridAreas;
    private Pointer pointer;
    private int renderingIndex;
    private AbstractDataProvider<?> data;
    private boolean allowEvents = false;
    SOChart soChart;

    public Axis(DataType dataType) {
        this.dataType = dataType;
    }

    public Axis(AbstractDataProvider<?> data) {
        this(data.getDataType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Axis axis = (Axis)o;
        return this.getId() == axis.getId();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    String axisName() {
        Class<?> c = this.getClass();
        while (!c.getName().startsWith("com.storedobject.chart")) {
            c = c.getSuperclass();
        }
        String name = c.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    Object value(Object value) {
        if (value == null) {
            return null;
        }
        if (this.dataType != null) {
            if (this.dataType == DataType.CATEGORY) {
                return value;
            }
            if (this.dataType == DataType.TIME && value instanceof LocalDate) {
                value = ((LocalDate)value).atStartOfDay();
            } else if (this.dataType == DataType.DATE && value instanceof LocalDateTime) {
                value = ((LocalDateTime)value).toLocalDate();
            }
            return this.dataType.getType().isAssignableFrom(value.getClass()) ? value : null;
        }
        for (DataType dt : DataType.values()) {
            if (!dt.getType().isAssignableFrom(value.getClass())) continue;
            this.dataType = dt;
            return value;
        }
        return value;
    }

    @Override
    public void validate() throws ChartException {
        if (this.dataType == null) {
            String name = this.getName();
            if (name == null) {
                name = ComponentPart.className(this.getClass());
            }
            throw new ChartException("Unable to determine the data type for this axis - " + name);
        }
    }

    public void setData(AbstractDataProvider<?> data) {
        this.data = data;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.data != null) {
            sb.append(",\"data\":").append(this.data.getSerial());
        }
        if (this.inverted) {
            sb.append(",\"inverse\":true");
        }
        sb.append(",\"type\":").append((Object)this.dataType);
        if (this.name != null) {
            ComponentPart.encode(sb, "name", this.name);
            if (this.nameLocation != null) {
                sb.append(",\"nameLocation\":").append((Object)this.nameLocation);
            }
            sb.append(",\"nameGap\":").append(this.nameGap);
            sb.append(",\"nameRotate\":").append(this.nameRotation);
            ComponentPart.encode(sb, "nameTextStyle", this.nameTextStyle);
        }
        ComponentPart.encode(sb, "axisLabel", this.label);
        this.min = this.value(this.min);
        if (this.min != null) {
            ComponentPart.encode(sb, "min", this.min);
        }
        this.max = this.value(this.max);
        if (this.max != null) {
            ComponentPart.encode(sb, "max", this.max);
        }
        if (this.dataType != DataType.CATEGORY) {
            if (this.divisions > 0) {
                sb.append(",\"splitNumber\":").append(this.divisions);
            }
            if (this.min == null && this.max == null) {
                sb.append(",\"scale\":").append(!this.showZero);
            }
        }
        ComponentPart.encode(sb, "axisTick", this.ticks);
        ComponentPart.encode(sb, "minorTick", this.minorTicks);
        ComponentPart.encode(sb, "splitLine", this.gridLines);
        ComponentPart.encode(sb, "minorSplitLine", this.minorGridLines);
        ComponentPart.encode(sb, "splitArea", this.gridAreas);
        ComponentPart.encode(sb, "axisPointer", this.pointer);
        ComponentPart.encode(sb, "silent", !this.allowEvents);
    }

    public void setAllowEvents(boolean allowEvents) {
        this.allowEvents = allowEvents;
    }

    public boolean isAllowEvents() {
        return this.allowEvents;
    }

    @Override
    public void setRenderingIndex(int renderingIndex) {
        this.renderingIndex = renderingIndex;
    }

    @Override
    public int getRenderingIndex() {
        return this.renderingIndex;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void invert() {
        this.inverted = true;
    }

    public int getNameGap() {
        return this.nameGap;
    }

    public void setNameGap(int nameGap) {
        this.nameGap = nameGap;
    }

    public int getNameRotation() {
        return this.nameRotation;
    }

    public void setNameRotation(int nameRotation) {
        this.nameRotation = nameRotation;
    }

    public Location getNameLocation() {
        return this.nameLocation;
    }

    public void setNameLocation(Location nameLocation) {
        this.nameLocation = Location.h(nameLocation);
    }

    public final TextStyle getNameTextStyle(boolean create) {
        if (this.nameTextStyle == null && create) {
            this.nameTextStyle = new TextStyle();
        }
        return this.nameTextStyle;
    }

    public void setNameTextStyle(TextStyle nameTextStyle) {
        this.nameTextStyle = nameTextStyle;
    }

    public void setMin(Number min) {
        this.min = this.value(min);
    }

    public void setMinAsMinData() {
        this.min = "dataMin";
    }

    public void setMax(Object max) {
        this.max = this.value(max);
    }

    public void setMaxAsMaxData() {
        this.max = "dataMax";
    }

    public void setDivisions(int divisions) {
        this.divisions = divisions;
    }

    public void showZeroPosition(boolean show) {
        this.showZero = show;
    }

    public final Label getLabel(boolean create) {
        if (this.label == null && create) {
            this.label = new Label();
        }
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public final Ticks getTicks(boolean create) {
        if (this.ticks == null && create) {
            this.ticks = new Ticks();
        }
        return this.ticks;
    }

    public void setTicks(Ticks ticks) {
        this.ticks = ticks;
    }

    public final MinorTicks getMinorTicks(boolean create) {
        if (this.minorTicks == null && create) {
            this.minorTicks = new MinorTicks();
        }
        return this.minorTicks;
    }

    public void setMinorTicks(MinorTicks ticks) {
        this.minorTicks = ticks;
    }

    public final GridLines getGridLines(boolean create) {
        if (this.gridLines == null && create) {
            this.gridLines = new GridLines();
        }
        return this.gridLines;
    }

    public void setGridLines(GridLines gridLines) {
        this.gridLines = gridLines;
    }

    public final MinorGridLines getMinorGridLines(boolean create) {
        if (this.minorGridLines == null && create) {
            this.minorGridLines = new MinorGridLines();
        }
        return this.minorGridLines;
    }

    public void setMinorGridLines(MinorGridLines gridLines) {
        this.minorGridLines = gridLines;
    }

    public final GridAreas getGridAreas(boolean create) {
        if (this.gridAreas == null && create) {
            this.gridAreas = new GridAreas();
        }
        return this.gridAreas;
    }

    public void setGridAreas(GridAreas gridAreas) {
        this.gridAreas = gridAreas;
    }

    public final Pointer getPointer(boolean create) {
        if (this.pointer == null && create) {
            this.pointer = new Pointer();
        }
        return this.pointer;
    }

    public void setPointer(Pointer pointer) {
        this.pointer = pointer;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private static void encodeJSON(StringBuilder sb, int interval) {
        if (interval >= -1) {
            ComponentPart.addComma(sb);
            sb.append("\"interval\":");
            if (interval == -1) {
                sb.append("\"auto\"");
            } else {
                sb.append(interval);
            }
        }
    }

    abstract ComponentPart wrap(CoordinateSystem var1);

    public static class Label
    extends com.storedobject.chart.Label {
        private Boolean showMaxLabel;
        private Boolean showMinLabel;
        private int interval = Integer.MIN_VALUE;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.showMinLabel != null) {
                sb.append(",\"showMinLabel\":").append(this.showMinLabel);
            }
            if (this.showMaxLabel != null) {
                sb.append(",\"showMaxLabel\":").append(this.showMaxLabel);
            }
            if (this.interval >= -1) {
                sb.append(",\"interval\":");
                if (this.interval == -1) {
                    sb.append("\"auto\"");
                } else {
                    sb.append(this.interval);
                }
            }
        }

        public final Boolean getShowMaxLabel() {
            return this.showMaxLabel;
        }

        public void setShowMaxLabel(Boolean showMaxLabel) {
            this.showMaxLabel = showMaxLabel;
        }

        public final Boolean getShowMinLabel() {
            return this.showMinLabel;
        }

        public void setShowMinLabel(Boolean showMinLabel) {
            this.showMinLabel = showMinLabel;
        }

        public final int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        @Override
        public void setFormatter(String formatter) {
            this.formatter = formatter;
            this.doNotEscapeFormat = false;
        }

        public void setFormatterFunction(String function) {
            this.formatter = ComponentPart.encodeFunction(function, "value", "index");
            this.doNotEscapeFormat = true;
        }
    }

    public static class Ticks
    extends AbstractTicks {
        private boolean inside = false;
        private int interval = Integer.MIN_VALUE;
        private boolean alignWithLabels;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"inside\":").append(this.inside);
            if (this.interval >= -1) {
                sb.append(",\"interval\":");
                if (this.interval == -1) {
                    sb.append("\"auto\"");
                } else {
                    sb.append(this.interval);
                }
            }
            sb.append(",\"alignWithLabel\":").append(this.alignWithLabels);
        }

        public boolean isInside() {
            return this.inside;
        }

        public void setInside(boolean inside) {
            this.inside = inside;
        }

        public final int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public final boolean isAlignWithLabels() {
            return this.alignWithLabels;
        }

        public void setAlignWithLabel(boolean alignWithLabels) {
            this.alignWithLabels = alignWithLabels;
        }
    }

    public static class MinorTicks
    extends AbstractTicks {
        private int divisions = 0;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.divisions > 0) {
                ComponentPart.addComma(sb);
                sb.append("\"splitNumber\":").append(this.divisions);
            }
        }

        public final int getDivisions() {
            return this.divisions;
        }

        public void setDivisions(int divisions) {
            this.divisions = divisions;
        }
    }

    public static class GridLines
    extends Line {
        private int interval = Integer.MIN_VALUE;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            Axis.encodeJSON(sb, this.interval);
        }

        public final int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }
    }

    public static class MinorGridLines
    extends Line {
    }

    public static class GridAreas
    extends Area {
        private int interval = Integer.MIN_VALUE;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            Axis.encodeJSON(sb, this.interval);
        }

        public final int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }
    }

    public static class Pointer
    extends VisiblePart {
        private PointerType type;
        private Boolean snap;
        private PointerLabel label;
        private Shadow shadow;
        private LineStyle lineStyle;
        private PointerHandle handle;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.type != null) {
                sb.append(",\"type\":\"").append(this.type.toString().toLowerCase()).append('\"');
            }
            if (this.snap != null) {
                sb.append(",\"snap\":").append(this.snap);
            }
            ComponentPart.encode(sb, "label", this.label);
            ComponentPart.encode(sb, "shadowStyle", this.shadow);
            ComponentPart.encode(sb, "handle", this.handle);
        }

        public PointerType getType() {
            return this.type;
        }

        public void setType(PointerType type) {
            this.type = type;
        }

        public Boolean getSnap() {
            return this.snap;
        }

        public void setSnap(Boolean snap) {
            this.snap = snap;
        }

        public final PointerLabel getLabel(boolean create) {
            if (this.label == null && create) {
                this.label = new PointerLabel();
            }
            return this.label;
        }

        public void setLabel(PointerLabel label) {
            this.label = label;
        }

        public LineStyle getLineStyle(boolean create) {
            if (this.lineStyle == null && create) {
                this.lineStyle = new LineStyle();
            }
            return this.lineStyle;
        }

        public void setLineStyle(LineStyle lineStyle) {
            this.lineStyle = lineStyle;
        }

        public final Shadow getShadow(boolean create) {
            if (this.shadow == null && create) {
                this.shadow = new Shadow();
            }
            return this.shadow;
        }

        public void setShadow(Shadow shadow) {
            this.shadow = shadow;
        }

        public final PointerHandle getHandle(boolean create) {
            if (this.handle == null && create) {
                this.handle = new PointerHandle();
            }
            return this.handle;
        }

        public void setHandle(PointerHandle handle) {
            this.handle = handle;
        }
    }

    static class AxisWrapper
    extends AbstractPart {
        private int renderingIndex = -1;
        final Axis axis;
        private final CoordinateSystem coordinateSystem;

        AxisWrapper(Axis axis, CoordinateSystem coordinateSystem) {
            this.axis = axis;
            this.coordinateSystem = coordinateSystem;
            this.axis.wrappers.put(this.coordinateSystem, this);
        }

        @Override
        public void setRenderingIndex(int index) {
            this.renderingIndex = index;
        }

        @Override
        public int getRenderingIndex() {
            return this.renderingIndex;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            for (SOChart.ComponentEncoder ce : SOChart.encoders) {
                if (this.coordinateSystem.getClass() != ce.partType) continue;
                ComponentPart.addComma(sb);
                sb.append('\"').append(ce.label).append("Index\":").append(this.coordinateSystem.getSerial());
                break;
            }
            this.axis.encodeJSON(sb);
        }

        @Override
        public void validate() throws ChartException {
            this.axis.validate();
        }
    }

    public static class PointerHandle
    extends VisiblePart {
        private int width = -1;
        private int height = -1;
        private int gap = -1;
        private Shadow shadow;
        private AbstractColor color;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.width > 0 || this.height > 0) {
                int w = this.width;
                int h = this.height;
                if (w <= 0) {
                    w = 45;
                }
                if (h <= 0) {
                    h = 45;
                }
                sb.append(",\"size\":");
                if (w == h) {
                    sb.append(w);
                } else {
                    sb.append('[').append(w).append(',').append(h).append(']');
                }
                if (this.gap >= 0) {
                    sb.append(",\"margin\":").append(this.gap);
                }
            }
            if (this.color != null) {
                sb.append(",\"color\":").append(this.color);
            }
            ComponentPart.encode(sb, null, this.shadow);
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setSize(int size) {
            this.width = size;
            this.height = size;
        }

        public int getGap() {
            return this.gap;
        }

        public void setGap(int gap) {
            this.gap = gap;
        }

        public AbstractColor getColor() {
            return this.color;
        }

        public void setColor(AbstractColor color) {
            this.color = color;
        }

        public final Shadow getShadow(boolean create) {
            if (this.shadow == null && create) {
                this.shadow = new Shadow();
            }
            return this.shadow;
        }

        public void setShadow(Shadow shadow) {
            this.shadow = shadow;
        }
    }

    public static class PointerLabel
    extends AbstractLabel {
        private int precision = -1;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"precision\":");
            if (this.precision >= 0) {
                sb.append(this.precision);
            } else {
                sb.append("\"auto\"");
            }
        }

        public final int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }
    }

    public static class Line
    extends VisiblePart {
        private LineStyle style;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.style != null) {
                ComponentPart.encode(sb, "lineStyle", this.style);
            }
        }

        public LineStyle getStyle(boolean create) {
            if (this.style == null && create) {
                this.style = new LineStyle();
            }
            return this.style;
        }

        public void setStyle(LineStyle style) {
            this.style = style;
        }
    }

    public static abstract class AbstractTicks
    extends Line {
        private int width = 0;

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.width > 0) {
                ComponentPart.addComma(sb);
                sb.append("\"length\":").append(this.width);
            }
        }

        public final int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }

    public static enum PointerType {
        LINE,
        CROSS_HAIR,
        NONE;

    }
}

