/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractProject;
import com.storedobject.chart.AbstractTask;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Color;
import com.storedobject.chart.DataType;
import com.storedobject.chart.SOChart;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ActivityList
extends AbstractProject {
    private final List<ActivityGroup> activityGroups = new ArrayList<ActivityGroup>();
    private boolean checked = false;

    public ActivityList() {
        this(null);
    }

    public ActivityList(ChronoUnit durationType) {
        super(durationType);
    }

    @Override
    void validateConstraints() throws ChartException {
        if (this.checked) {
            return;
        }
        super.validateConstraints();
        this.arrange();
        for (ActivityGroup activityGroup : this.activityGroups) {
            activityGroup.check();
        }
        this.checked = true;
    }

    private void arrange() {
        this.activityGroups.removeIf(tg -> tg.activities.isEmpty());
        this.activityGroups.forEach(ActivityGroup::sort);
    }

    @Override
    public boolean isEmpty() {
        return this.activityGroups.isEmpty();
    }

    public ActivityGroup createActivityGroup(String name) {
        ActivityGroup activityGroup = new ActivityGroup(name);
        this.activityGroups.addFirst(activityGroup);
        return activityGroup;
    }

    public Activity createActivity(ActivityGroup activityGroup, String activityName, LocalDateTime start, int duration) {
        if (this.activityGroups.contains(activityGroup)) {
            return new Activity(activityGroup, activityName, start, duration);
        }
        return null;
    }

    public Activity createActivity(ActivityGroup activityGroup, String activityName, LocalDateTime start, LocalDateTime end) {
        if (this.activityGroups.contains(activityGroup)) {
            return new Activity(activityGroup, activityName, start, end);
        }
        return null;
    }

    private void deleteActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        this.checked = false;
        activity.group.activities.remove(activity);
    }

    private void deleteGroup(ActivityGroup activityGroup) {
        if (activityGroup == null) {
            return;
        }
        this.checked = false;
        this.activityGroups.remove(activityGroup);
        while (!activityGroup.activities.isEmpty()) {
            this.deleteActivity(activityGroup.activities.getFirst());
        }
    }

    public void delete(ActivityGroup ... activityGroups) {
        if (activityGroups != null) {
            for (ActivityGroup activityGroup : activityGroups) {
                this.deleteGroup(activityGroup);
            }
        }
    }

    public void delete(Activity ... activities) {
        if (activities != null) {
            for (Activity activity : activities) {
                this.deleteActivity(activity);
            }
        }
    }

    @Override
    public final void setStart(LocalDateTime start) {
        this.checked = false;
        super.setStart(start);
    }

    @Override
    public final LocalDateTime getStart() {
        LocalDateTime start = super.getStart();
        if (start == null) {
            this.arrange();
            if (!this.isEmpty()) {
                start = this.activityGroups.getFirst().getStart();
            }
        }
        return start;
    }

    @Override
    public final LocalDateTime getEnd() {
        LocalDateTime start;
        LocalDateTime end = start = this.getStart();
        for (ActivityGroup activityGroup : this.activityGroups) {
            for (Activity activity : activityGroup.activities) {
                LocalDateTime e = activity.getEnd();
                if (!e.isAfter(end)) continue;
                end = e;
            }
        }
        return end;
    }

    private static int compare(ProjectActivity a1, ProjectActivity a2) {
        return a2.getStart().compareTo(a1.getStart());
    }

    @Override
    public final int getRowCount() {
        return this.activityGroups.size();
    }

    public final ActivityGroup getEventGroup(int groupIndex) {
        return this.activityGroups.get(groupIndex);
    }

    public final int getGroupCount() {
        return this.activityGroups.size();
    }

    @Override
    boolean isEmptyGroup() {
        return this.activityGroups.isEmpty();
    }

    public Stream<ActivityGroup> streamGroups() {
        try {
            this.validateConstraints();
        }
        catch (ChartException e) {
            return null;
        }
        return this.activityGroups.stream();
    }

    public Stream<Activity> streamActivities(ActivityGroup activityGroup) {
        try {
            this.validateConstraints();
        }
        catch (ChartException e) {
            return null;
        }
        return activityGroup.activities.stream();
    }

    @Override
    public <T> Iterator<T> iterator(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> activityFilter) {
        return new ActivityIterator<T>(function, activityFilter);
    }

    @Override
    final int renderingPosition(AbstractTask activity, int index) {
        return this.activityGroups.indexOf(((Activity)activity).group);
    }

    @Override
    protected final String getExtraAxisLabel(AbstractTask activity) {
        String string;
        if (activity instanceof ActivityGroup) {
            ActivityGroup g = (ActivityGroup)activity;
            string = this.getExtraAxisLabel(g);
        } else {
            string = "";
        }
        return string;
    }

    protected String getExtraAxisLabel(ActivityGroup activityGroup) {
        return activityGroup.getExtraInfo();
    }

    @Override
    final String getAxisLabel(AbstractTask abstractActivity, int index) {
        ActivityGroup group = ((Activity)abstractActivity).group;
        return "[" + this.activityGroups.indexOf(group) + ",\"\",0,\"" + this.nullAsEmpty(group.getName()) + "\",\"" + this.nullAsEmpty(this.getExtraAxisLabel(group)) + "\"," + String.valueOf(group.getColor()) + "," + this.groupFontSize(group) + "," + this.extraFontSize(group) + "]";
    }

    @Override
    AbstractDataProvider<String> axisLabels() {
        return this.dataProvider(DataType.OBJECT, this::getAxisLabel, t -> ((Activity)t).group.activities.getFirst() == t);
    }

    public class ActivityGroup
    extends ProjectActivity {
        private final List<Activity> activities;

        ActivityGroup(String name) {
            super(name, LocalDateTime.now(), 0);
            this.activities = new ArrayList<Activity>();
        }

        public Activity createActivity(String name, LocalDateTime start, int duration) {
            return ActivityList.this.createActivity(this, name, start, duration);
        }

        public Activity createActivity(String name, LocalDateTime start, LocalDateTime end) {
            return ActivityList.this.createActivity(this, name, start, end);
        }

        @Override
        public Color getColor() {
            Color color = super.getColor();
            if (color == null) {
                color = SOChart.getDefaultColor(ActivityList.this.activityGroups.indexOf(this));
                this.setColor(color);
            }
            return color;
        }

        private void sort() {
            this.activities.sort(ActivityList::compare);
        }

        @Override
        public final int getDuration() {
            LocalDateTime start = this.activities.getFirst().getStart();
            LocalDateTime end = this.activities.getLast().getEnd();
            return (int)ActivityList.this.getDurationType().between(start, end);
        }

        @Override
        public final LocalDateTime getStart() {
            return this.activities.getFirst().getStart();
        }

        public final Activity getActivity(int activityIndex) {
            return this.activities.get(activityIndex);
        }

        public final int getActivityCount() {
            return this.activities.size();
        }

        @Override
        public boolean isCompleted() {
            return this.activities.stream().allMatch(AbstractTask::isCompleted);
        }

        @Override
        public double getCompleted() {
            return 0.0;
        }

        @Override
        protected void check() throws ChartException {
            Activity p = this.activities.getFirst();
            p.check();
            for (int i = 1; i < this.activities.size(); ++i) {
                Activity c = this.activities.get(i);
                c.check();
                if (!p.getStart().isBefore(c.getEnd())) continue;
                throw new ChartException(String.valueOf(p) + " overlaps with " + String.valueOf(c));
            }
        }
    }

    public class Activity
    extends ProjectActivity {
        private final ActivityGroup group;
        private double completed;

        Activity(ActivityGroup activityGroup, String name, LocalDateTime start, int duration) {
            super(name, ActivityList.this.trim(start), duration);
            this.completed = 0.0;
            this.group = activityGroup;
            this.group.activities.add(this);
        }

        Activity(ActivityGroup activityGroup, String name, LocalDateTime start, LocalDateTime end) {
            super(name, ActivityList.this.trim(start), end);
            this.completed = 0.0;
            this.group = activityGroup;
            this.group.activities.add(this);
        }

        public Activity createNext(String name, int gap, int duration) {
            return this.group.createActivity(name, this.getEnd().plus(gap, ActivityList.this.getDurationType()), duration);
        }

        public Activity createNext(String name, int duration) {
            return this.createNext(name, 1, duration);
        }

        public void setCompleted(double completed) {
            this.completed = Math.min(Math.max(0.0, completed), 100.0);
        }

        @Override
        public final double getCompleted() {
            return this.completed;
        }

        @Override
        public final boolean isMilestone() {
            return this.getDuration() == 0;
        }

        public final ActivityGroup getGroup() {
            return this.group;
        }

        @Override
        public boolean isCompleted() {
            return this.completed >= 100.0 || this.getDuration() == 0;
        }

        @Override
        public Color getColor() {
            Color color = super.getColor();
            return color == null ? this.group.getColor() : color;
        }

        @Override
        protected void check() throws ChartException {
            if (this.getDuration() <= 0) {
                throw new ChartException("Invalid duration in " + String.valueOf(this));
            }
        }

        public String toString() {
            Function<LocalDateTime, String> timeConverter = ActivityList.this.getTooltipTimeFormat();
            return "[" + this.getName() + " (" + timeConverter.apply(this.getStart()) + " - " + timeConverter.apply(this.getEnd()) + ")]";
        }
    }

    public abstract class ProjectActivity
    extends AbstractTask {
        private final int duration;

        protected ProjectActivity(String name, LocalDateTime start, int duration) {
            this.setName(name);
            this.start = start;
            this.duration = Math.max(duration, 0);
        }

        protected ProjectActivity(String name, LocalDateTime start, LocalDateTime end) {
            this.setName(name);
            this.start = start;
            this.duration = (int)ActivityList.this.getDurationType().between(start, end);
        }

        @Override
        public final String getName() {
            String name = super.getName();
            if (name != null && !name.isEmpty()) {
                return "DEFAULT".equals(name) ? "" : name;
            }
            return (this instanceof Activity ? "Activity" : "Group") + ": " + this.getId();
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public final LocalDateTime getEnd() {
            return this.getStart().plus(this.getDuration(), ActivityList.this.getDurationType());
        }

        @Override
        public LocalDateTime renderStart() {
            if (this.getDuration() == 0) {
                return this.start.minus(1L, ActivityList.this.getDurationType());
            }
            return this.start;
        }

        protected abstract void check() throws ChartException;
    }

    private class ActivityIterator<T>
    extends AbstractProject.ElementIterator<T> {
        private ActivityIterator(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> activityFilter) {
            super(function, activityFilter);
        }

        @Override
        void checkNext() {
            ActivityGroup activityGroup = ActivityList.this.activityGroups.get(this.groupIndex);
            while (this.taskIndex >= activityGroup.activities.size()) {
                if (++this.groupIndex >= ActivityList.this.activityGroups.size()) {
                    this.groupIndex = Integer.MIN_VALUE;
                    this.next = null;
                    return;
                }
                activityGroup = ActivityList.this.activityGroups.get(this.groupIndex);
                if (activityGroup.activities.isEmpty()) continue;
                this.taskIndex = 0;
                break;
            }
            ++this.index;
            this.next = activityGroup.getActivity(this.taskIndex);
        }
    }
}

