/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Color;
import com.storedobject.helper.ID;
import java.time.LocalDateTime;
import java.util.Objects;

public abstract class AbstractTask {
    private final long id = ID.newID();
    private String name;
    private String extraInfo;
    private Color color;
    private int fontSize = 0;
    private int extraFontSize = 0;
    LocalDateTime start = null;

    public boolean isMilestone() {
        return false;
    }

    public final long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public abstract int getDuration();

    public abstract LocalDateTime getEnd();

    public abstract double getCompleted();

    public LocalDateTime renderStart() {
        return this.getStart();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getExtraFontSize() {
        return this.extraFontSize;
    }

    public void setExtraFontSize(int extraFontSize) {
        this.extraFontSize = extraFontSize;
    }

    public boolean isCompleted() {
        return this.getCompleted() >= 100.0;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTask)) {
            return false;
        }
        AbstractTask that = (AbstractTask)o;
        return this.id == that.id;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }
}

