/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractTask;
import com.storedobject.chart.BasicDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Color;
import com.storedobject.chart.DataType;
import com.storedobject.helper.ID;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractProject {
    private final long id = ID.newID();
    private String name;
    private final ChronoUnit durationType;
    private LocalDateTime start = null;
    private Function<LocalDateTime, String> todayFormat;
    private Function<LocalDateTime, String> tooltipTimeFormat;
    private LocalDateTime today;
    private Color todayColor;
    private String bandColorEven;
    private String bandColorOdd;
    private int taskFontSize = 12;
    private int groupFontSize = 12;
    private int extraFontSize = 9;

    public AbstractProject(ChronoUnit durationType) {
        if (durationType == null) {
            durationType = ChronoUnit.DAYS;
        } else {
            durationType = switch (durationType) {
                case ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS -> durationType;
                default -> ChronoUnit.MILLIS;
            };
        }
        this.durationType = durationType;
        this.today = durationType.isDateBased() ? LocalDate.now().atStartOfDay() : LocalDateTime.now();
    }

    public final ChronoUnit getDurationType() {
        return this.durationType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name == null || this.name.isEmpty() ? "Project " + this.id : this.name;
    }

    boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    abstract int getRowCount();

    protected LocalDateTime trim(LocalDateTime dateTime) {
        return dateTime.truncatedTo(this.durationType);
    }

    public void setStart(LocalDateTime start) {
        this.start = this.trim(start);
    }

    public final void setStart(LocalDate start) {
        this.setStart(start.atStartOfDay());
    }

    public final void setStart(Instant start) {
        this.setStart(LocalDateTime.from(start));
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public abstract LocalDateTime getEnd();

    void validateConstraints() throws ChartException {
        if (this.getStart() == null) {
            throw new ChartException("Project start not specified");
        }
    }

    protected static LocalDateTime max(LocalDateTime one, LocalDateTime two) {
        if (one == null && two == null) {
            return null;
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return one.isBefore(two) ? two : one;
    }

    protected final String encode(LocalDateTime time) {
        return "\"" + String.valueOf(this.durationType.isDateBased() ? time.toLocalDate() : time) + "\"";
    }

    private <T> Stream<T> taskData(BiFunction<AbstractTask, Integer, T> encoder, Predicate<AbstractTask> taskFilter) {
        return StreamSupport.stream(new TaskIterable<T>(encoder, taskFilter).spliterator(), false);
    }

    AbstractDataProvider<String> bands() {
        if (this.bandColorOdd == null) {
            this.bandColorOdd = "#D9E1F2";
        }
        if (this.bandColorEven == null) {
            this.bandColorEven = "#EEF0F3";
        }
        if (!this.bandColorOdd.startsWith("\"")) {
            this.bandColorOdd = "\"" + this.bandColorOdd + "\"";
        }
        if (!this.bandColorEven.startsWith("\"")) {
            this.bandColorEven = "\"" + this.bandColorEven + "\"";
        }
        LocalDateTime end = this.getEnd();
        return this.dataProvider(DataType.OBJECT, (t, i) -> "[" + i + "," + this.encode(this.start) + "," + this.encode(end) + "," + (i % 2 == 0 ? this.bandColorEven : this.bandColorOdd) + "]");
    }

    protected static String trim(double v) {
        String t = String.valueOf(v);
        if (t.endsWith(".0")) {
            t = t.substring(0, t.indexOf(46));
        }
        return t;
    }

    protected String getLabel(AbstractTask task) {
        if (task.isMilestone()) {
            return task.getName();
        }
        return task.getName() + " (" + AbstractProject.trim(task.getCompleted()) + "%)";
    }

    AbstractDataProvider<String> taskData() {
        BiFunction<AbstractTask, Integer, String> func = (t, i) -> "[" + this.renderingPosition((AbstractTask)t, (int)i) + ",\"" + this.getLabel((AbstractTask)t) + "\"," + this.encode(t.renderStart()) + "," + this.encode(t.getEnd()) + "," + (t.isMilestone() ? 100.0 : t.getCompleted()) + "," + String.valueOf(t.getColor()) + ",\"black\",\"black\"," + this.taskFontSize((AbstractTask)t) + "]";
        return this.dataProvider(DataType.OBJECT, func);
    }

    int groupFontSize(AbstractTask t) {
        int f = t.getFontSize();
        return f <= 0 ? this.getGroupFontSize() : f;
    }

    int taskFontSize(AbstractTask t) {
        int f = t.getFontSize();
        return f <= 0 ? this.getTaskFontSize() : f;
    }

    int extraFontSize(AbstractTask t) {
        int f = t.getExtraFontSize();
        return f <= 0 ? this.getExtraFontSize() : f;
    }

    int renderingPosition(AbstractTask task, int index) {
        return index;
    }

    AbstractDataProvider<String> dependencies() {
        return null;
    }

    public final LocalDateTime getToday() {
        return this.today;
    }

    protected abstract String getExtraAxisLabel(AbstractTask var1);

    protected String getAxisLabel(AbstractTask task) {
        return task.getName();
    }

    abstract String getAxisLabel(AbstractTask var1, int var2);

    abstract AbstractDataProvider<String> axisLabels();

    protected String getTooltipLabel(AbstractTask task) {
        Object extra = this.nullAsEmpty(task.getExtraInfo());
        if (!((String)extra).isEmpty()) {
            extra = "<br>" + (String)extra;
        }
        Function<LocalDateTime, String> timeConverter = this.getTooltipTimeFormat();
        String s = this.getLabel(task) + "<br>" + timeConverter.apply(task.start);
        if (task.isMilestone()) {
            return s + (String)extra;
        }
        return s + " - " + timeConverter.apply(task.getEnd()) + " (" + task.getDuration() + ")" + (String)extra;
    }

    final AbstractDataProvider<String> tooltipLabels() {
        return this.dataProvider(DataType.CATEGORY, (t, i) -> "\"" + this.getTooltipLabel((AbstractTask)t) + "\"");
    }

    <T> AbstractDataProvider<T> dataProvider(DataType dataType, BiFunction<AbstractTask, Integer, T> encoder) {
        return this.dataProvider(dataType, encoder, null);
    }

    <T> AbstractDataProvider<T> dataProvider(final DataType dataType, final BiFunction<AbstractTask, Integer, T> encoder, final Predicate<AbstractTask> taskFilter) {
        return new BasicDataProvider<T>(this){
            final /* synthetic */ AbstractProject this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Stream<T> stream() {
                return this.this$0.taskData(encoder, taskFilter);
            }

            @Override
            public DataType getDataType() {
                return dataType;
            }

            @Override
            public void encode(StringBuilder sb, T value) {
                sb.append(value);
            }
        };
    }

    AbstractDataProvider<?> dataForToday() {
        return new BasicDataProvider<Object>(){

            @Override
            public Stream<Object> stream() {
                return Stream.of("");
            }

            @Override
            public void encode(StringBuilder sb, Object value) {
                if (AbstractProject.this.todayColor == null) {
                    AbstractProject.this.todayColor = new Color("#FF000");
                }
                sb.append("[").append(AbstractProject.this.encode(AbstractProject.this.today)).append(",\"").append(AbstractProject.this.getTodayFormat().apply(AbstractProject.this.today)).append("\",").append(AbstractProject.this.todayColor).append(",100]");
            }
        };
    }

    public void setToday(LocalDate today) {
        this.today = today.atStartOfDay();
    }

    public void setTodayColor(Color color) {
        this.todayColor = color;
    }

    public void setTimeNow(LocalDateTime now) {
        this.today = now;
    }

    public void setTimeNowColor(Color color) {
        this.todayColor = color;
    }

    public void setTodayFormat(Function<LocalDateTime, String> todayFormat) {
        this.todayFormat = todayFormat;
    }

    public void setTooltipTimeFormat(Function<LocalDateTime, String> tooltipTimeFormat) {
        this.tooltipTimeFormat = tooltipTimeFormat;
    }

    private String timePattern() {
        StringBuilder s = new StringBuilder("MMM dd, yyyy");
        if (!this.durationType.isDateBased()) {
            s.append(' ');
            switch (this.durationType) {
                case SECONDS: {
                    s.append("HH:mm:ss");
                    break;
                }
                case MINUTES: {
                    s.append("HH:mm");
                    break;
                }
                case HOURS: {
                    s.append("HH");
                    break;
                }
                default: {
                    s.append("HH:mm:ss.S");
                }
            }
        }
        return s.toString();
    }

    Function<LocalDateTime, String> getTodayFormat() {
        if (this.todayFormat == null) {
            String s = this.timePattern();
            String name = this.durationType.isDateBased() ? "Date" : "Time";
            this.todayFormat = d -> name + ": " + DateTimeFormatter.ofPattern(s).format((TemporalAccessor)d);
        }
        return this.todayFormat;
    }

    Function<LocalDateTime, String> getTooltipTimeFormat() {
        if (this.tooltipTimeFormat == null) {
            String s = this.timePattern();
            this.tooltipTimeFormat = d -> DateTimeFormatter.ofPattern(s).format((TemporalAccessor)d);
        }
        return this.tooltipTimeFormat;
    }

    public void setTaskBandColors(Color bandColorOdd, Color bandColorEven) {
        this.bandColorOdd = bandColorOdd.toString();
        this.bandColorEven = bandColorEven.toString();
    }

    public int getExtraFontSize() {
        return this.extraFontSize;
    }

    public void setExtraFontSize(int extraFontSize) {
        this.extraFontSize = extraFontSize;
    }

    public int getGroupFontSize() {
        return this.groupFontSize;
    }

    public void setGroupFontSize(int groupFontSize) {
        this.groupFontSize = groupFontSize <= 0 ? 12 : groupFontSize;
    }

    public int getTaskFontSize() {
        return this.taskFontSize;
    }

    public void setTaskFontSize(int taskFontSize) {
        this.taskFontSize = taskFontSize <= 0 ? 12 : taskFontSize;
    }

    public int getActivityFontSize() {
        return this.taskFontSize;
    }

    public void setActivityFontSize(int activityFontSize) {
        this.setTaskFontSize(activityFontSize);
    }

    abstract boolean isEmptyGroup();

    public <T> Stream<T> stream(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> taskFilter) {
        return StreamSupport.stream(new TaskIterable<T>(function, taskFilter).spliterator(), false);
    }

    public <T> Iterable<T> iterable(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> taskFilter) {
        return new TaskIterable<T>(function, taskFilter);
    }

    public abstract <T> Iterator<T> iterator(BiFunction<AbstractTask, Integer, T> var1, Predicate<AbstractTask> var2);

    String nullAsEmpty(String s) {
        return s == null ? "" : s;
    }

    private class TaskIterable<T>
    implements Iterable<T> {
        private final BiFunction<AbstractTask, Integer, T> encoder;
        private final Predicate<AbstractTask> taskFilter;

        private TaskIterable(BiFunction<AbstractTask, Integer, T> encoder, Predicate<AbstractTask> taskFilter) {
            this.encoder = encoder;
            this.taskFilter = taskFilter;
        }

        @Override
        public Iterator<T> iterator() {
            return AbstractProject.this.iterator(this.encoder, this.taskFilter);
        }
    }

    abstract class ElementIterator<T>
    implements Iterator<T> {
        int index = -1;
        int groupIndex = -1;
        int taskIndex = -1;
        AbstractTask next = null;
        final BiFunction<AbstractTask, Integer, T> function;
        final Predicate<AbstractTask> taskFilter;

        ElementIterator(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> taskFilter) {
            this.function = function;
            this.taskFilter = taskFilter;
        }

        @Override
        public final boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.groupIndex == Integer.MIN_VALUE) {
                return false;
            }
            if (this.groupIndex == -1) {
                if (AbstractProject.this.isEmptyGroup()) {
                    this.groupIndex = Integer.MIN_VALUE;
                    return false;
                }
                this.groupIndex = 0;
                this.taskIndex = 0;
            } else {
                ++this.taskIndex;
            }
            this.checkNext();
            if (this.next == null) {
                return false;
            }
            if (this.taskFilter != null && !this.taskFilter.test(this.next)) {
                this.next = null;
                return this.hasNext();
            }
            return true;
        }

        abstract void checkNext();

        @Override
        public final T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            AbstractTask task = this.next;
            this.next = null;
            return this.function.apply(task, this.index);
        }
    }
}

