/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractPart;
import com.storedobject.chart.Axis;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.CoordinateSystem;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractDataZoom
extends AbstractPart
implements Component {
    private final String type;
    private final List<Axis> axes = new ArrayList<Axis>();
    private final CoordinateSystem coordinateSystem;
    private int filterMode = Integer.MAX_VALUE;
    private int start = Integer.MIN_VALUE;
    private int end = Integer.MAX_VALUE;
    private Object startValue;
    private Object endValue;
    private int minSpan = Integer.MIN_VALUE;
    private int maxSpan = Integer.MAX_VALUE;
    private Object minSpanValue;
    private Object maxSpanValue;
    private boolean zoomLock;
    private boolean showDetail = true;

    AbstractDataZoom(String type, CoordinateSystem coordinateSystem, Axis ... axes) {
        this.type = type;
        this.coordinateSystem = coordinateSystem;
        this.addAxis(axes);
    }

    public void addAxis(Axis ... axes) {
        if (axes != null) {
            for (Axis a : axes) {
                if (a == null || this.axes.contains(a)) continue;
                this.axes.add(a);
            }
        }
    }

    @Override
    public void validate() throws ChartException {
        if (this.coordinateSystem.getSerial() < 0) {
            throw new ChartException("Coordinate system is not used");
        }
        if (this.axes.isEmpty()) {
            this.axes.addAll(this.coordinateSystem.axes);
            return;
        }
        for (Axis a : this.axes) {
            if (this.coordinateSystem.axes.contains(a)) continue;
            String name = a.getName();
            if (name == null) {
                name = ComponentPart.className(a.getClass());
            }
            throw new ChartException("Axis " + name + " doesn't belong to the coordinate system of this");
        }
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.encode(sb, "type", this.type);
        HashSet axisClasses = new HashSet();
        this.axes.forEach(a -> axisClasses.add(a.getClass()));
        axisClasses.forEach(ac -> {
            AtomicBoolean first = new AtomicBoolean(true);
            this.axes.stream().filter(a -> a.getClass() == ac).forEach(a -> {
                if (first.get()) {
                    first.set(false);
                    sb.append(",\"").append(a.axisName()).append("Index\":[");
                } else {
                    sb.append(',');
                }
                sb.append(a.wrap(this.coordinateSystem).getSerial());
            });
            sb.append(']');
        });
        if (this.filterMode != Integer.MAX_VALUE) {
            sb.append(",\"filterMode\":\"");
            switch (this.filterMode) {
                case 0: {
                    sb.append("none");
                    break;
                }
                case 1: {
                    sb.append("empty");
                    break;
                }
                case 2: {
                    sb.append("weakFilter");
                    break;
                }
                case 3: {
                    sb.append("filter");
                    this.filterMode = Integer.MAX_VALUE;
                }
            }
            sb.append("\"");
        }
        if (this.start != Integer.MIN_VALUE || this.end != Integer.MAX_VALUE || this.startValue != null || this.endValue != null) {
            sb.append(",\"rangeMode\":[\"");
            sb.append(this.startValue != null ? "value" : "percent");
            sb.append("\",\"");
            sb.append(this.endValue != null ? "value" : "percent");
            sb.append("\"]");
        }
        if (this.start != Integer.MIN_VALUE) {
            sb.append(",\"start\":").append(this.start);
            if (this.start == 0) {
                this.start = Integer.MIN_VALUE;
            }
        }
        if (this.end != Integer.MAX_VALUE) {
            sb.append(",\"end\":").append(this.end);
            if (this.end == 100) {
                this.end = Integer.MAX_VALUE;
            }
        }
        if (this.startValue != null) {
            ComponentPart.encode(sb, "startValue", this.startValue);
        }
        if (this.endValue != null) {
            ComponentPart.encode(sb, "endValue", this.endValue);
        }
        if (this.minSpan != Integer.MIN_VALUE) {
            sb.append(",\"minSpan\":").append(this.minSpan);
            if (this.minSpan == 0) {
                this.minSpan = Integer.MIN_VALUE;
            }
        }
        if (this.maxSpan != Integer.MAX_VALUE) {
            sb.append(",\"maxSpan\":").append(this.maxSpan);
            if (this.maxSpan == 100) {
                this.maxSpan = Integer.MAX_VALUE;
            }
        }
        if (this.minSpanValue != null) {
            ComponentPart.encode(sb, "minValueSpan", this.minSpanValue);
        }
        if (this.maxSpanValue != null) {
            ComponentPart.encode(sb, "maxValueSpan", this.maxSpanValue);
        }
        ComponentPart.encode(sb, "zoomLock", this.zoomLock);
        ComponentPart.encode(sb, "showDetail", this.showDetail);
    }

    public void setShowDetail(boolean showDetail) {
        this.showDetail = showDetail;
    }

    public final int getFilterMode() {
        return this.filterMode == Integer.MAX_VALUE ? 3 : this.filterMode;
    }

    public void setFilterMode(int filterMode) {
        this.filterMode = filterMode >= 0 && filterMode <= 3 ? filterMode : Integer.MAX_VALUE;
    }

    public final int getStart() {
        return this.start == Integer.MIN_VALUE ? 0 : this.start;
    }

    public void setStart(int start) {
        this.start = start >= 0 && start < 100 ? start : Integer.MIN_VALUE;
        this.startValue = null;
    }

    public final int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end > 0 && end <= 100 ? end : Integer.MAX_VALUE;
    }

    public final Object getStartValue() {
        return this.startValue;
    }

    public void setStartValue(Number startValue) {
        this.startValue = startValue;
        this.start = Integer.MIN_VALUE;
    }

    public void setStartValue(LocalDate startValue) {
        this.startValue = startValue;
        this.start = Integer.MIN_VALUE;
    }

    public void setStartValue(LocalDateTime startValue) {
        this.startValue = startValue;
        this.start = Integer.MIN_VALUE;
    }

    public final Object getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Number endValue) {
        this.endValue = endValue;
        this.end = Integer.MAX_VALUE;
    }

    public void setEndValue(LocalDate endValue) {
        this.endValue = endValue;
        this.end = Integer.MAX_VALUE;
    }

    public void setEndValue(LocalDateTime endValue) {
        this.endValue = endValue;
        this.end = Integer.MAX_VALUE;
    }

    public final int getMinSpan() {
        return this.minSpan == Integer.MIN_VALUE ? 0 : this.minSpan;
    }

    public void setMinSpan(int minSpan) {
        this.minSpan = minSpan >= 0 && minSpan < 100 ? minSpan : Integer.MIN_VALUE;
        this.minSpanValue = null;
    }

    public final int getMaxSpan() {
        return this.maxSpan;
    }

    public void setMaxSpan(int maxSpan) {
        this.maxSpan = maxSpan > 0 && maxSpan <= 100 ? maxSpan : Integer.MAX_VALUE;
    }

    public final Object getMinSpanValue() {
        return this.minSpanValue;
    }

    public void setMinSpanValue(Number minSpanValue) {
        this.minSpanValue = minSpanValue;
        this.minSpan = Integer.MIN_VALUE;
    }

    public void setMinSpanValue(LocalDate minSpanValue) {
        this.minSpanValue = minSpanValue;
        this.minSpan = Integer.MIN_VALUE;
    }

    public void setMinSpanValue(LocalDateTime minSpanValue) {
        this.minSpanValue = minSpanValue;
        this.minSpan = Integer.MIN_VALUE;
    }

    public final Object getMaxSpanValue() {
        return this.maxSpanValue;
    }

    public void setMaxSpanValue(Number maxSpanValue) {
        this.maxSpanValue = maxSpanValue;
        this.maxSpan = Integer.MAX_VALUE;
    }

    public void setMaxSpanValue(LocalDate maxSpanValue) {
        this.maxSpanValue = maxSpanValue;
        this.maxSpan = Integer.MAX_VALUE;
    }

    public void setMaxSpanValue(LocalDateTime maxSpanValue) {
        this.maxSpanValue = maxSpanValue;
        this.maxSpan = Integer.MAX_VALUE;
    }

    public final boolean isZoomLock() {
        return this.zoomLock;
    }

    public void setZoomLock(boolean zoomLock) {
        this.zoomLock = zoomLock;
    }
}

