/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface AbstractDataProvider<T>
extends ComponentPart {
    public Stream<T> stream();

    default public List<T> asList() {
        if (this instanceof List) {
            return (List)((Object)this);
        }
        ArrayList list = new ArrayList();
        this.stream().forEach(list::add);
        return list;
    }

    public DataType getDataType();

    @Override
    default public String getName() {
        return "Data " + this.getSerial();
    }

    @Override
    default public void encodeJSON(StringBuilder sb) {
        sb.append('[');
        AtomicBoolean first = new AtomicBoolean(true);
        this.stream().forEach(v -> {
            if (first.get()) {
                first.set(false);
            } else {
                sb.append(',');
            }
            this.encode(sb, v);
        });
        sb.append(']');
    }

    default public void encode(StringBuilder sb, T value) {
        sb.append(ComponentPart.escape(value));
    }

    @Override
    default public long getId() {
        return -1L;
    }

    @Override
    default public void validate() throws ChartException {
    }

    default public Object getMin() {
        if (this.getDataType() == DataType.CATEGORY) {
            return this.stream().findFirst().orElse(null);
        }
        Comparator<T> comparator = this.getComparator();
        return comparator == null ? null : this.stream().min(this.getComparator()).orElse(null);
    }

    default public Object getMax() {
        if (this.getDataType() == DataType.CATEGORY) {
            AtomicReference<Object> value = new AtomicReference<Object>(null);
            this.stream().forEach(value::set);
            return value.get();
        }
        Comparator<T> comparator = this.getComparator();
        return comparator == null ? null : this.stream().max(this.getComparator()).orElse(null);
    }

    default public Comparator<T> getComparator() {
        return this.getDataType() == DataType.NUMBER ? new NumberComparator() : null;
    }

    default public <D> AbstractDataProvider<D> create(final DataType convertedType, final BiFunction<T, Integer, D> mappingFunction) {
        return new AbstractDataProvider<D>(this){
            private int serial = -1;
            final /* synthetic */ AbstractDataProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Stream<D> stream() {
                AtomicInteger index = new AtomicInteger(0);
                return this.this$0.stream().map(item -> mappingFunction.apply(item, index.getAndIncrement()));
            }

            @Override
            public DataType getDataType() {
                return convertedType;
            }

            @Override
            public void setSerial(int serial) {
                this.serial = serial;
            }

            @Override
            public int getSerial() {
                return this.serial;
            }
        };
    }

    default public <D> AbstractDataProvider<D> create(DataType convertedType, Function<T, D> mappingFunction) {
        return this.create(convertedType, (T item, Integer index) -> mappingFunction.apply(item));
    }

    public static class NumberComparator
    implements Comparator<Number> {
        @Override
        public int compare(Number n1, Number n2) {
            if (n1 == null || n2 == null) {
                return n1 == null && n2 == null ? 0 : (n1 == null ? -1 : 1);
            }
            return new BigDecimal(n1.toString()).compareTo(new BigDecimal(n2.toString()));
        }
    }
}

