/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataType;

public abstract class XYAxis
extends Axis {
    private boolean opposite = false;
    private int offset = 0;
    private boolean inverse;

    public XYAxis(DataType dataType) {
        super(dataType);
    }

    public XYAxis(AbstractDataProvider<?> data) {
        super(data);
    }

    abstract String positionString();

    @Override
    public void encodeJSON(StringBuilder sb) {
        int offset;
        super.encodeJSON(sb);
        if (this.opposite) {
            sb.append(',');
            ComponentPart.encode(sb, "position", this.positionString());
        }
        if ((offset = this.getOffset()) > 0) {
            sb.append(',');
            ComponentPart.encode(sb, "offset", offset);
        }
        if (this.opposite || offset > 0) {
            sb.append(",\"axisLine\":{\"onZero\":false}");
        }
        sb.append(",\"inverse\":").append(this.inverse);
    }

    public final boolean isOpposite() {
        return this.opposite;
    }

    public void setOpposite(boolean opposite) {
        this.opposite = opposite;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public final boolean isInverse() {
        return this.inverse;
    }
}

