/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.HasData;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.VisiblePart;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Tooltip
extends VisiblePart
implements Component,
HasData {
    private Type type = null;
    final List<Object> parts = new ArrayList<Object>();

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.type != null) {
            ComponentPart.encode(sb, "trigger", String.valueOf((Object)this.type).toLowerCase());
        }
        if (!this.parts.isEmpty()) {
            ComponentPart.addComma(sb);
            sb.append("\"formatter\":");
            sb.append("{\"functionP\":{");
            sb.append("\"body\":[");
            boolean first = true;
            for (Object p : this.parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (p instanceof String) {
                    String s = (String)p;
                    s = s.replace("\n", "<br>");
                    sb.append(ComponentPart.escape(s));
                    continue;
                }
                if (p instanceof AbstractDataProvider) {
                    sb.append(((AbstractDataProvider)p).getSerial());
                    continue;
                }
                Chart chart = (Chart)p;
                AbstractDataProvider<?> d = chart.dataValue();
                if (d == null) continue;
                int dataIndex = chart.dataValueIndex();
                if (dataIndex < 0) {
                    sb.append(d.getSerial());
                    continue;
                }
                sb.append('[').append(d.getSerial()).append(',').append(dataIndex).append(']');
            }
            sb.append("]}}");
        }
    }

    @Override
    public void validate() {
    }

    public final Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Tooltip append(String part) {
        if (part != null && !part.isBlank()) {
            if (this.parts.isEmpty()) {
                this.parts.add(part);
            } else {
                Object last = this.parts.get(this.parts.size() - 1);
                if (last instanceof String) {
                    this.parts.remove(this.parts.size() - 1);
                    this.append(String.valueOf(last) + part);
                } else {
                    this.parts.add(part);
                }
            }
        }
        return this;
    }

    public Tooltip newline() {
        return this.append("<br>");
    }

    public Tooltip append(AbstractDataProvider<?> data) {
        this.parts.add(data);
        return this;
    }

    public Tooltip append(Chart chart) {
        this.parts.add(chart);
        return this;
    }

    @Override
    public void declareData(Set<AbstractDataProvider<?>> dataSet) {
        this.parts.stream().filter(p -> p instanceof AbstractDataProvider).map(p -> (AbstractDataProvider)p).forEach(dataSet::add);
    }

    @Override
    public void addParts(SOChart soChart) {
        this.parts.stream().filter(p -> p instanceof AbstractDataProvider).map(p -> (AbstractDataProvider)p).forEach(soChart::addData);
    }

    public static enum Type {
        Item,
        Axis,
        None;

    }
}

