/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.Position;
import com.storedobject.chart.ToolboxButton;
import com.storedobject.chart.VisiblePart;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.YAxis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Toolbox
extends VisiblePart
implements Component,
HasPosition {
    private final List<ToolboxButton> buttons = new ArrayList<ToolboxButton>();
    private Position position;
    private boolean vertical = false;

    public Toolbox() {
    }

    public Toolbox(ToolboxButton ... buttons) {
        this.addButton(buttons);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.vertical) {
            ComponentPart.encode(sb, "orient", "vertical");
        }
        if (this.show) {
            ComponentPart.addComma(sb);
            sb.append("\"feature\":{");
            for (ToolboxButton button : this.buttons) {
                if (!(button instanceof Internal)) continue;
                sb.append('\"').append(((Internal)((Object)button)).getTag()).append("\":{");
                button.encodeJSON(sb);
                sb.append("},");
            }
            ComponentPart.removeComma(sb);
            sb.append('}');
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        this.position = position;
    }

    public void showVertically() {
        this.vertical = true;
    }

    public void addButton(ToolboxButton ... buttons) {
        if (buttons != null) {
            this.buttons.addAll(Arrays.asList(buttons));
        }
    }

    public void removeButton(ToolboxButton ... buttons) {
        if (buttons != null) {
            this.buttons.removeAll(Arrays.asList(buttons));
        }
    }

    private static interface Internal {
        public String getTag();
    }

    public static class DataView
    extends ToolboxButton
    implements Internal {
        public DataView() {
            this.setCaption("Data View");
        }

        @Override
        public String getTag() {
            return "dataView";
        }
    }

    public static final class Zoom
    extends ToolboxButton
    implements Internal {
        private String resetCaption = "Reset zoom";
        private XAxis[] xAxes = null;
        private YAxis[] yAxes = null;

        public Zoom() {
            this.setCaption("Zoom in");
        }

        @Override
        public String getTag() {
            return "dataZoom";
        }

        @Override
        protected void encodeCaptionJSON(StringBuilder sb) {
            if (this.xAxes != null) {
                sb.append(",\"xAxisIndex\":");
                if (this.xAxes.length == 0) {
                    sb.append("false");
                } else {
                    sb.append('[').append(Stream.of(this.xAxes).map(a -> String.valueOf(a.getRenderingIndex())).collect(Collectors.joining(","))).append(']');
                }
            }
            if (this.yAxes != null) {
                sb.append(",\"yAxisIndex\":");
                if (this.yAxes.length == 0) {
                    sb.append("false");
                } else {
                    sb.append('[').append(Stream.of(this.yAxes).map(a -> String.valueOf(a.getRenderingIndex())).collect(Collectors.joining(","))).append(']');
                }
            }
            String c = this.getCaption();
            String rc = this.getResetCaption();
            if (c == null && rc == null) {
                return;
            }
            sb.append(",\"title\":{");
            if (c != null) {
                ComponentPart.encode(sb, "zoom", c);
            }
            if (rc != null) {
                if (c != null) {
                    sb.append(',');
                }
                ComponentPart.encode(sb, "back", rc);
            }
            sb.append('}');
        }

        public String getResetCaption() {
            return this.resetCaption;
        }

        public void setResetCaption(String resetCaption) {
            this.resetCaption = resetCaption;
        }

        public void setXAxes(XAxis ... xAxes) {
            this.xAxes = xAxes;
        }

        public void setYAxes(YAxis ... yAxes) {
            this.yAxes = yAxes;
        }
    }

    public static final class Restore
    extends ToolboxButton
    implements Internal {
        public Restore() {
            this.setCaption("Restore");
        }

        @Override
        public String getTag() {
            return "restore";
        }
    }

    public static final class Download
    extends ToolboxButton
    implements Internal {
        private int resolution = 1;

        public Download() {
            this.setCaption("Download as image");
        }

        @Override
        public String getTag() {
            return "saveAsImage";
        }

        public int getResolution() {
            return this.resolution;
        }

        public void setResolution(int resolution) {
            this.resolution = resolution;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(',');
            ComponentPart.encode(sb, "name", "sochart");
            if (this.resolution > 1) {
                sb.append(',');
                ComponentPart.encode(sb, "pixelRatio", this.resolution);
            }
        }
    }
}

