/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.Alignment;
import com.storedobject.chart.Border;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.Font;
import com.storedobject.chart.Padding;
import com.storedobject.chart.RichTextStyle;
import com.storedobject.chart.TextBorder;

public class TextStyle
implements ComponentProperty {
    private AbstractColor color;
    private AbstractColor background;
    private Font font;
    private Padding padding;
    private Border border;
    private Alignment alignment;
    private TextBorder textBorder;
    private RichTextStyle richTextStyle;

    @Override
    public void encodeJSON(StringBuilder sb) {
        TextStyle.encode(sb, "color", this.color);
        if (this.font != null) {
            if (this.font.getStyle() != null) {
                TextStyle.encode(sb, "fontStyle", (Object)this.font.getStyle());
            }
            if (this.font.getWeight() != null) {
                TextStyle.encode(sb, "fontWeight", this.font.getWeight());
            }
            TextStyle.encode(sb, "fontFamily", this.font.getFamily());
            TextStyle.encode(sb, "fontSize", this.font.getSize());
        }
        TextStyle.encode(sb, "backgroundColor", this.background);
        ComponentPart.encode(sb, null, this.border);
        ComponentPart.encode(sb, null, this.padding);
        ComponentPart.encode(sb, null, this.alignment);
        if (this.textBorder != null) {
            this.textBorder.setPrefix("text");
        }
        ComponentPart.encode(sb, null, this.textBorder);
        if (this.richTextStyle != null && !this.richTextStyle.parts.isEmpty()) {
            ComponentPart.addComma(sb);
            sb.append("\"rich\":{");
            this.richTextStyle.parts.forEach((p, s) -> {
                sb.append('\"').append((String)p).append("\":{");
                ComponentPart.encode(sb, null, s);
                sb.append("},");
            });
            ComponentPart.removeComma(sb);
            sb.append('}');
        }
    }

    private static void encode(StringBuilder sb, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Integer && (Integer)value <= 0) {
            return;
        }
        ComponentPart.addComma(sb);
        if (value instanceof AbstractColor) {
            sb.append('\"').append(name).append("\":").append(value);
            return;
        }
        ComponentPart.encode(sb, name, value);
    }

    public final AbstractColor getColor() {
        return this.color;
    }

    public void setColor(AbstractColor color) {
        this.color = color;
    }

    public final AbstractColor getBackground() {
        return this.background;
    }

    public void setBackground(AbstractColor background) {
        this.background = background;
    }

    public final Font getFontStyle() {
        return this.font;
    }

    public void setFontStyle(Font font) {
        this.font = font;
    }

    public final Padding getPadding(boolean create) {
        if (this.padding == null && create) {
            this.padding = new Padding();
        }
        return this.padding;
    }

    public void setPadding(Padding padding) {
        this.padding = padding;
    }

    public final Border getBorder(boolean create) {
        if (this.border == null && create) {
            this.border = new Border();
        }
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public final TextBorder getTextBorder(boolean create) {
        if (this.textBorder == null && create) {
            this.textBorder = new TextBorder();
        }
        return this.textBorder;
    }

    public final void setTextBorder(TextBorder textBorder) {
        this.textBorder = textBorder;
    }

    public Alignment getAlignment(boolean create) {
        if (this.alignment == null && create) {
            this.alignment = new Alignment();
        }
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public RichTextStyle getRichTextStyle(boolean create) {
        if (create && this.richTextStyle == null) {
            this.richTextStyle = new RichTextStyle();
        }
        return this.richTextStyle;
    }

    public void setRichTextStyle(RichTextStyle richTextStyle) {
        this.richTextStyle = richTextStyle;
    }

    void save(OuterProperties op) {
        op.background = this.background;
        this.background = null;
        op.padding = this.padding;
        this.padding = null;
        op.border = this.border;
        this.border = null;
        op.alignment = this.alignment;
        this.alignment = null;
    }

    void restore(OuterProperties op) {
        this.background = op.background;
        this.padding = op.padding;
        this.border = op.border;
        this.alignment = op.alignment;
    }

    static class OuterProperties {
        AbstractColor background;
        Padding padding;
        Border border;
        Alignment alignment;

        OuterProperties() {
        }
    }
}

