/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Alignment;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.Font;
import com.storedobject.chart.Shape;

public class Text
extends Shape {
    private final TextContent text = new TextContent();

    public Text(String text) {
        this.text.text = text;
        this.getStyle((boolean)true).extra = this.text;
        this.text.alignment = new Alignment();
        this.text.alignment.center();
    }

    @Override
    protected final String getType() {
        return "text";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        sb.deleteCharAt(sb.length() - 1);
    }

    @Override
    public void setStyle(Shape.Style style) {
        super.setStyle(style);
        this.getStyle((boolean)true).extra = this.text;
    }

    public String getText() {
        return this.text.text;
    }

    public void setText(String text) {
        this.text.text = text;
    }

    public void setFont(Font font) {
        this.text.font = font;
    }

    public Font getFont() {
        return this.text.font;
    }

    public Alignment getAlignment(boolean create) {
        if (this.text.alignment == null && create) {
            this.text.alignment = new Alignment();
        }
        return this.text.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.text.alignment = alignment;
    }

    private static class TextContent
    implements ComponentProperty {
        String text;
        Font font;
        Alignment alignment;

        private TextContent() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            ComponentPart.encode(sb, "text", this.text);
            if (this.font != null) {
                ComponentPart.encode(sb, "font", this.font);
            }
            if (this.alignment != null) {
                sb.append(',');
                this.alignment.setPrefix("text");
                this.alignment.encodeJSON(sb);
            }
        }
    }
}

