/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractPart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Color;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.Position;
import com.storedobject.chart.Shadow;
import com.storedobject.chart.VisibleProperty;

public abstract class Shape
extends AbstractPart
implements Component,
HasPosition,
VisibleProperty {
    private static final Color DEFAULT_COLOR = new Color("black");
    private Position position;
    private Point positionXY;
    private Style style;
    private boolean draggable = false;
    private boolean show = true;

    public Shape() {
        this.getStyle(true).setFillColor(DEFAULT_COLOR);
        this.style.setStrokeColor(DEFAULT_COLOR);
    }

    protected abstract String getType();

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.encode(sb, "type", this.getType());
        if (this.positionXY != null) {
            Shape.encodePoint(sb, this.positionXY);
        }
        ComponentPart.encode(sb, "invisible", !this.show);
        ComponentPart.encode(sb, "draggable", this.draggable);
        if (this.style != null) {
            sb.append(",\"style\":{");
            this.style.encodeJSON(sb);
            sb.append('}');
        }
        sb.append(',');
    }

    protected static void encode(StringBuilder sb, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < o.length; ++i) {
                Object oo = o[i];
                s.append(i == 0 ? (char)'[' : ',').append(oo == null ? "null" : ComponentPart.escape(oo));
            }
            if (s.isEmpty()) {
                return;
            }
            value = s.append(']').toString();
            ComponentPart.addComma(sb);
            sb.append('\"').append(name).append("\":").append(value);
            return;
        }
        ComponentPart.encode(sb, name, value);
    }

    protected static void encodePoint(StringBuilder sb, String nameX, String nameY, Point point) {
        if (point == null) {
            return;
        }
        Shape.encode(sb, nameX, point.x);
        Shape.encode(sb, nameY, point.y);
    }

    protected static void encodePoint(StringBuilder sb, Point point) {
        if (point == null) {
            return;
        }
        Shape.encode(sb, "x", point.x);
        Shape.encode(sb, "y", point.y);
    }

    protected void encodeShape(StringBuilder sb) {
    }

    @Override
    public void validate() throws ChartException {
    }

    @Override
    public void setVisible(boolean visible) {
        this.show = visible;
    }

    @Override
    public boolean isVisible() {
        return this.show;
    }

    public final boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        if (!create && this.positionXY != null) {
            return null;
        }
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        this.position = position;
    }

    public void setPosition(Point positionXY) {
        this.positionXY = positionXY;
    }

    public void setPosition(Number positionX, Number positionY) {
        this.positionXY = new Point(positionX, positionY);
    }

    public final Style getStyle(boolean create) {
        if (this.style == null && create) {
            this.style = new Style();
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public static class Style
    implements ComponentProperty {
        private AbstractColor fillColor;
        private AbstractColor strokeColor;
        private Number lineWidth;
        private Shadow shadow;
        ComponentProperty extra;

        @Override
        public void encodeJSON(StringBuilder sb) {
            if (this.fillColor != null) {
                ComponentPart.encode(sb, "fill", this.fillColor.toString());
            }
            if (this.strokeColor != null) {
                ComponentPart.encode(sb, "stroke", this.strokeColor.toString());
            }
            ComponentPart.encode(sb, "lineWidth", this.lineWidth == null ? (Number)1 : (Number)this.lineWidth);
            if (this.extra != null) {
                this.extra.encodeJSON(sb);
            }
            ComponentPart.encode(sb, null, this.shadow);
        }

        public final AbstractColor getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(AbstractColor fillColor) {
            this.fillColor = fillColor;
        }

        public final AbstractColor getStrokeColor() {
            return this.strokeColor;
        }

        public void setStrokeColor(AbstractColor strokeColor) {
            this.strokeColor = strokeColor;
        }

        public final Number getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(Number lineWidth) {
            this.lineWidth = lineWidth;
        }

        public final Shadow getShadow(boolean create) {
            if (this.shadow == null && create) {
                this.shadow = new Shadow();
            }
            return this.shadow;
        }

        public void setShadow(Shadow shadow) {
            this.shadow = shadow;
        }
    }

    public static class Point {
        Number x;
        Number y;

        public Point(Number x, Number y) {
            this.setX(x);
            this.setY(y);
        }

        public final Number getX() {
            return this.x;
        }

        public void setX(Number x) {
            this.x = x;
        }

        public final Number getY() {
            return this.y;
        }

        public void setY(Number y) {
            this.y = y;
        }

        public String toString() {
            return "[" + String.valueOf(this.x == null ? "0" : this.x) + "," + String.valueOf(this.y == null ? "0" : this.y) + "]";
        }
    }
}

