/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;

public class Shadow
implements ComponentProperty {
    private String prefix;
    private AbstractColor color;
    private int blur = Integer.MIN_VALUE;
    private int offsetX = Integer.MIN_VALUE;
    private int offsetY = Integer.MIN_VALUE;
    private int opacity = Integer.MIN_VALUE;

    @Override
    public void encodeJSON(StringBuilder sb) {
        if (this.color != null) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(this.p("shadowColor")).append("\":").append(this.color);
        }
        if (this.blur > Integer.MIN_VALUE) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(this.p("shadowBlur")).append("\":").append(this.blur);
        }
        if (this.offsetX > Integer.MIN_VALUE) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(this.p("shadowOffsetX")).append("\":").append(this.offsetX);
        }
        if (this.offsetY > Integer.MIN_VALUE) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(this.p("shadowOffsetY")).append("\":").append(this.offsetY);
        }
        if (this.opacity >= 0) {
            ComponentPart.addComma(sb);
            sb.append("\"opacity\":").append((double)Math.min(100, this.opacity) / 100.0);
        }
        this.prefix = null;
    }

    private String p(String any) {
        if (this.prefix == null) {
            return any;
        }
        return this.prefix + any.substring(0, 1).toUpperCase() + any.substring(1);
    }

    public final int getBlur() {
        return this.blur;
    }

    public void setBlur(int blur) {
        this.blur = blur;
    }

    public final AbstractColor getColor() {
        return this.color;
    }

    public void setColor(AbstractColor color) {
        this.color = color;
    }

    public final int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public final int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }
}

