/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;

public class SerialTime
implements AbstractDataProvider<LocalDateTime> {
    private final LocalDateTime start;
    private final LocalDateTime end;
    private final int step;
    private final ChronoUnit stepUnit;
    private int serial;

    public SerialTime(LocalDateTime start, LocalDateTime end) {
        this(start, end, 0, null);
    }

    public SerialTime(LocalDateTime start, LocalDateTime end, ChronoUnit stepUnit) {
        this(start, end, 0, stepUnit);
    }

    public SerialTime(LocalDateTime start, LocalDateTime end, int step, ChronoUnit stepUnit) {
        ChronoUnit chronoUnit = this.stepUnit = stepUnit == null ? ChronoUnit.MINUTES : stepUnit;
        int n = step == 0 ? (start.isBefore(end) ? 1 : -1) : (this.step = step);
        if (this.step > 0) {
            this.start = start.isBefore(end) ? start : end;
            this.end = end.isAfter(start) ? end : start;
        } else {
            this.start = start.isAfter(end) ? start : end;
            this.end = end.isBefore(start) ? end : start;
        }
    }

    public SerialTime(long start, long end) {
        this(start, end, 0);
    }

    public SerialTime(long start, long end, int step) {
        this(LocalDateTime.ofEpochSecond(start, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(start, 0, ZoneOffset.UTC), step, ChronoUnit.MILLIS);
    }

    @Override
    public Stream<LocalDateTime> stream() {
        return Stream.iterate(this.start, t -> this.step > 0 ? !t.isAfter(this.end) : !t.isBefore(this.end), t -> t.plus(this.step, this.stepUnit));
    }

    @Override
    public final DataType getDataType() {
        return DataType.TIME;
    }

    @Override
    public final void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public final int getSerial() {
        return this.serial;
    }
}

