/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;

public class SerialDate
implements AbstractDataProvider<LocalDate> {
    private final LocalDate start;
    private final LocalDate end;
    private final int step;
    private final ChronoUnit stepUnit;
    private int serial;

    public SerialDate(LocalDate start, LocalDate end) {
        this(start, end, 0);
    }

    public SerialDate(LocalDate start, LocalDate end, int step) {
        this(start, end, step, ChronoUnit.DAYS);
    }

    public SerialDate(LocalDate start, LocalDate end, int step, ChronoUnit stepUnit) {
        this.stepUnit = stepUnit;
        int n = step == 0 ? (start.isBefore(end) ? 1 : -1) : (this.step = step);
        if (this.step > 0) {
            this.start = start.isBefore(end) ? start : end;
            this.end = end.isAfter(start) ? end : start;
        } else {
            this.start = start.isAfter(end) ? start : end;
            this.end = end.isBefore(start) ? end : start;
        }
    }

    @Override
    public Stream<LocalDate> stream() {
        return Stream.iterate(this.start, d -> this.step > 0 ? !d.isAfter(this.end) : !d.isBefore(this.end), d -> d.plus(this.step, this.stepUnit));
    }

    @Override
    public final DataType getDataType() {
        return DataType.DATE;
    }

    @Override
    public final void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public final int getSerial() {
        return this.serial;
    }
}

