/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractData;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComposedPart;
import com.storedobject.chart.DataType;
import com.storedobject.chart.Label;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.SankeyDataProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class SankeyData
extends AbstractData<Node>
implements SankeyDataProvider {
    private final List<Edge> edges = new ArrayList<Edge>();

    public SankeyData(Node ... nodes) {
        super(DataType.OBJECT, nodes);
    }

    public void addEdge(Edge edge) {
        Node from = edge.getFrom();
        Node to = edge.getTo();
        if (from == null || to == null) {
            this.edges.add(edge);
            return;
        }
        if (this.stream().noneMatch(n -> n.getName().equals(from.getName()))) {
            this.add(from);
        }
        if (this.stream().noneMatch(n -> n.getName().equals(to.getName()))) {
            this.add(to);
        }
        this.edges.add(edge);
    }

    @Override
    public Stream<Node> getNodes() {
        return this.stream();
    }

    @Override
    public Stream<Edge> getEdges() {
        return this.edges.stream();
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        for (int i = 0; i < this.size(); ++i) {
            String name = ((Node)this.get(i)).getName();
            for (int j = i + 1; j < this.size(); ++j) {
                if (!((Node)this.get(j)).getName().equals(name)) continue;
                throw new ChartException("Duplicate node name - " + name);
            }
        }
        for (Edge e : this.edges) {
            e.validate();
        }
        if (this.edges.isEmpty()) {
            return;
        }
        if (this.hasCircularReference()) {
            throw new ChartException("Circular edge detected");
        }
    }

    private boolean hasCircularReference() {
        HashSet<Node> visitedNodes = new HashSet<Node>();
        for (Edge edge : this.edges) {
            Node fromNode = edge.getFrom();
            if (visitedNodes.contains(fromNode) || !this.hasCycle(fromNode, visitedNodes, new HashSet<Node>())) continue;
            return true;
        }
        return false;
    }

    private boolean hasCycle(Node node, Set<Node> visited, Set<Node> path) {
        visited.add(node);
        path.add(node);
        for (Edge edge : this.edges) {
            Node toNode;
            if (edge.getFrom() != node || !(!visited.contains(toNode = edge.getTo()) ? this.hasCycle(toNode, visited, path) : path.contains(toNode))) continue;
            return true;
        }
        path.remove(node);
        return false;
    }

    public static class Edge
    extends ComposedPart {
        private final Node from;
        private final Node to;
        private Number value;
        private LineStyle lineStyle;

        public Edge(Node from, Node to, Number value) {
            super(false, false, false, false, true, true, true, false);
            this.from = from;
            this.to = to;
            this.value = value;
        }

        @Override
        protected boolean hasId() {
            return false;
        }

        public Node getFrom() {
            return this.from;
        }

        public Node getTo() {
            return this.to;
        }

        @Override
        public void validate() throws ChartException {
            if (this.from == null || this.to == null) {
                throw new ChartException("Invalid edge");
            }
        }

        public void setValue(Number value) {
            this.value = value;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "source", this.from.getName());
            ComponentPart.encode(sb, "target", this.to.getName());
            ComponentPart.encode(sb, "value", this.value);
            if (this.lineStyle != null) {
                ComponentPart.encode(sb, "lineStyle", this.lineStyle);
            }
        }

        @Override
        protected Class<? extends Label> getLabelClass() {
            return Chart.Label.class;
        }

        @Override
        protected String getLabelTag() {
            return "edgeLabel";
        }

        public final void setLineStyle(LineStyle lineStyle) {
            this.lineStyle = lineStyle;
        }

        public final LineStyle getLineStyle(boolean create) {
            if (this.lineStyle == null && create) {
                this.lineStyle = new LineStyle();
            }
            return this.lineStyle;
        }
    }

    public static class Node
    extends ComposedPart {
        private final String name;
        private Number value;
        private int depth = -1;

        public Node(String name) {
            super(false, false, false, false, false, true, true, true);
            this.name = name == null ? "NULL" : name;
        }

        @Override
        protected boolean hasId() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "name", this.getName());
            if (this.depth >= 0) {
                ComponentPart.encode(sb, "depth", this.depth);
            }
            if (this.value != null) {
                ComponentPart.encode(sb, "value", this.value);
            }
        }

        @Override
        protected Class<? extends Label> getLabelClass() {
            return Chart.Label.class;
        }
    }
}

