/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Border;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.XYAxis;
import com.storedobject.chart.YAxis;

public class RectangularCoordinate
extends CoordinateSystem {
    private Border border;
    private boolean sizeIncludeLabels = false;

    public RectangularCoordinate(XYAxis ... axes) {
        this.addAxis(axes);
    }

    @Override
    public void validate() throws ChartException {
        if (this.noAxis(XAxis.class)) {
            throw new ChartException("X Axis not set");
        }
        if (this.noAxis(YAxis.class)) {
            throw new ChartException("Y Axis not set");
        }
        super.validate();
    }

    public final Border getBorder(boolean create) {
        if (this.border == null && create) {
            this.border = new Border();
        }
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.encode(sb, null, this.border);
        if (this.sizeIncludeLabels) {
            ComponentPart.encode(sb, "containLabel", true);
        }
    }

    public void sizeIncludesLabels() {
        this.sizeIncludeLabels = true;
    }

    @Override
    String systemName() {
        return "cartesian2d";
    }
}

