/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.DataProvider;
import com.storedobject.chart.DataType;
import com.storedobject.chart.InternalDataProvider;
import com.storedobject.chart.RadarCoordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class RadarChart
extends Chart {
    private final List<DataProvider> dataList = new ArrayList<DataProvider>();
    private final RadarData data = new RadarData();

    public RadarChart(DataProvider ... data) {
        super(ChartType.Radar, new AbstractDataProvider[0]);
        super.setData(this.data);
        this.addData(data);
    }

    @Override
    public void setData(AbstractDataProvider<?> ... data) {
    }

    public void addData(DataProvider ... data) {
        if (data != null) {
            for (DataProvider d : data) {
                if (d == null) continue;
                this.dataList.add(d);
            }
        }
    }

    public void removeData(DataProvider ... data) {
        if (data != null) {
            for (DataProvider d : data) {
                if (d == null) continue;
                this.dataList.remove(d);
            }
        }
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (!(this.coordinateSystem instanceof RadarCoordinate)) {
            throw new ChartException("Radar chart should be plotted on a Radar Coordinate system: " + this.className());
        }
        if (this.dataList.isEmpty()) {
            throw new ChartException("No data set for " + this.className());
        }
        for (int i = 0; i < this.dataList.size(); ++i) {
            String name = this.dataList.get(i).getName();
            if (name != null) continue;
            this.dataList.get(i).setName("Data " + i);
        }
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.data;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
    }

    private class RadarData
    implements AbstractDataProvider<DataProvider>,
    InternalDataProvider {
        private int serial = -1;

        private RadarData() {
        }

        @Override
        public Stream<DataProvider> stream() {
            return RadarChart.this.dataList.stream();
        }

        @Override
        public void encode(StringBuilder sb, DataProvider value) {
            String name = value.getName();
            sb.append("{\"name\":\"").append(name == null ? "Data" : name).append("\",\"value\":");
            value.encodeJSON(sb);
            sb.append('}');
        }

        @Override
        public DataType getDataType() {
            return DataType.OBJECT;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }
    }
}

