/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Polygon;
import com.storedobject.chart.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Polyline
extends Shape {
    private static final Double MIN = -10000.0;
    private final List<Shape.Point> points = new ArrayList<Shape.Point>();
    private boolean clipSmooth;
    private double smoothness = MIN;

    public Polyline(Shape.Point ... points) {
        this.add(points);
    }

    @Override
    protected String getType() {
        return this instanceof Polygon ? "polygon" : "polyline";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        this.points.removeIf(Objects::isNull);
        sb.append("\"shape\":{\"points\":[");
        for (int i = 0; i < this.points.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.points.get(i));
        }
        sb.append(']');
        if (this.smoothness < 0.0) {
            if (!(this.smoothness < -10.0)) {
                sb.append(",\"smooth\":\"spline\"");
            }
        } else {
            if (this.smoothness > 1.0) {
                this.smoothness = 1.0;
            }
            sb.append(",\"smooth\":").append(this.smoothness);
            this.clipSmooth = false;
            sb.append(",\"smoothConstraint\":").append(this.clipSmooth);
        }
        sb.append('}');
    }

    public void add(int index, Shape.Point ... points) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.points.size()) {
            this.add(points);
            return;
        }
        if (points != null) {
            for (Shape.Point p : points) {
                this.points.add(index, p);
                ++index;
            }
        }
    }

    public void add(int index, Collection<Shape.Point> points) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.points.size()) {
            this.add(points);
            return;
        }
        if (points != null) {
            for (Shape.Point p : points) {
                this.points.add(index, p);
                ++index;
            }
        }
    }

    public void add(Shape.Point ... points) {
        if (points != null) {
            Collections.addAll(this.points, points);
        }
    }

    public void add(Collection<Shape.Point> points) {
        if (points != null) {
            this.points.addAll(points);
        }
    }

    public void remove(int index) {
        if (index >= 0 && index < this.points.size()) {
            this.points.remove(index);
        }
    }

    public void remove(Shape.Point ... points) {
        if (points != null) {
            for (Shape.Point p : points) {
                this.points.remove(p);
            }
        }
    }

    public void remove(Collection<Shape.Point> points) {
        if (points != null) {
            for (Shape.Point p : points) {
                this.points.remove(p);
            }
        }
    }

    public void useNoSmoothening() {
        this.smoothness = MIN;
    }

    public void useBezierSmoothening(double smoothness, boolean clip) {
        this.smoothness = smoothness;
        this.clipSmooth = clip;
    }

    public void useCatmullRomSmoothening() {
        this.smoothness = -1.0;
    }
}

