/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractLabel;
import com.storedobject.chart.ComponentPart;
import java.util.function.Function;

public abstract class Label
extends AbstractLabel {
    private int rotation = Integer.MIN_VALUE;
    private boolean inside = false;
    protected String formatter;
    protected Function<String, String> formatParser;
    protected boolean doNotEscapeFormat = false;

    public final int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public final boolean isInside() {
        return this.inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        String f;
        super.encodeJSON(sb);
        ComponentPart.addComma(sb);
        sb.append("\"inside\":").append(this.inside);
        if (this.rotation >= -90 && this.rotation <= 90) {
            sb.append(",\"rotate\":").append(this.rotation);
        }
        if (this.formatter != null && (f = this.getFormatterValue()) != null) {
            sb.append(",\"formatter\":").append(f);
        }
    }

    String getFormatterValue() {
        String f;
        String string = f = this.formatParser == null ? this.formatter : this.formatParser.apply(this.formatter);
        if (!this.doNotEscapeFormat) {
            f = ComponentPart.escape(f);
        }
        return f;
    }

    public final String getFormatter() {
        return this.formatter;
    }

    public abstract void setFormatter(String var1);
}

