/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.Shape;

public class Image
extends Shape {
    private final ImageContent image = new ImageContent();

    public Image(String imageURL) {
        this.image.imageURL = imageURL;
        this.getStyle((boolean)true).extra = this.image;
    }

    @Override
    protected String getType() {
        return "image";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        sb.deleteCharAt(sb.length() - 1);
    }

    @Override
    public void setStyle(Shape.Style style) {
        super.setStyle(style);
        this.getStyle((boolean)true).extra = this.image;
    }

    public String getImageURL() {
        return this.image.imageURL;
    }

    public void setImageURL(String imageURL) {
        this.image.imageURL = imageURL;
    }

    public final Number getWidth() {
        return this.image.width;
    }

    public void setWidth(Number width) {
        this.image.width = width;
    }

    public final Number getHeight() {
        return this.image.height;
    }

    public void setHeight(Number height) {
        this.image.height = height;
    }

    private static class ImageContent
    implements ComponentProperty {
        String imageURL;
        Number width;
        Number height;

        private ImageContent() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            ComponentPart.encode(sb, "image", this.imageURL);
            if (this.width != null && this.width.doubleValue() > 0.0) {
                ComponentPart.encode(sb, "width", this.width);
            }
            if (this.height != null && this.height.doubleValue() > 0.0) {
                ComponentPart.encode(sb, "height", this.height);
            }
        }
    }
}

