/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.BasicDataProvider;
import com.storedobject.chart.BasicInternalDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.Offset;
import com.storedobject.chart.PointSymbol;
import com.storedobject.chart.PointSymbolType;
import com.storedobject.chart.TextLabel;
import com.storedobject.helper.ID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class GraphData<N extends Node> {
    private final List<N> nodes = new ArrayList<N>();
    private AbstractDataProvider<N> nd;
    private boolean roam = false;
    private boolean draggable = false;
    private boolean autoCurveness = true;
    private PointSymbol edgeStartSymbol = new PointSymbol();
    private PointSymbol edgeEndSymbol = new PointSymbol(PointSymbolType.ARROW);
    private Category defaultCategory = new Category("Default");
    private final List<Category> categories = new ArrayList<Category>();
    private Layout layout = Layout.FORCE;
    private Offset center = null;
    private Force force;
    private TextLabel textLabel = new TextLabel();

    public GraphData() {
        this.defaultCategory.setSize(10);
    }

    AbstractDataProvider<N> getNodeData(boolean internal) {
        if (this.nd != null && (internal && this.nd instanceof NodeData || !internal && this.nd instanceof InternalNodeData)) {
            this.nd = null;
        }
        if (this.nd == null) {
            this.nd = internal ? new InternalNodeData() : new NodeData();
        }
        return this.nd;
    }

    boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    public GraphData<N> defaultCategory(Category defaultCategory) {
        this.setDefaultCategory(defaultCategory);
        return this;
    }

    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory == null ? new Category("Default") : defaultCategory;
    }

    public TextLabel getTextLabel() {
        return this.textLabel;
    }

    public void setTextLabel(TextLabel textLabel) {
        this.textLabel = textLabel;
    }

    public void setCenter(Offset center) {
        this.center = center;
    }

    public GraphData<N> center(Offset center) {
        this.setCenter(center);
        return this;
    }

    public Offset getCenter(boolean createIfNotExist) {
        if (this.center == null && createIfNotExist) {
            this.center = new Offset();
        }
        return this.center;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public GraphData<N> layout(Layout layout) {
        this.layout = layout;
        return this;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setRoam(boolean roam) {
        this.roam = roam;
    }

    public GraphData<N> roam(boolean roam) {
        this.roam = roam;
        return this;
    }

    public boolean isRoam() {
        return this.roam;
    }

    public Force getForce(boolean createIfNotExist) {
        if (this.force == null && createIfNotExist) {
            this.force = new Force();
        }
        return this.force;
    }

    public GraphData<N> force(Force force) {
        this.force = force;
        return this;
    }

    public void setForce(Force force) {
        this.force = force;
    }

    public void setAutoCurveness(boolean autoCurveness) {
        this.autoCurveness = autoCurveness;
    }

    public GraphData<N> autoCurveness(boolean autoCurveness) {
        this.autoCurveness = autoCurveness;
        return this;
    }

    public boolean isAutoCurveness() {
        return this.autoCurveness;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public GraphData<N> draggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public final PointSymbol getEdgeStartSymbol() {
        return this.edgeStartSymbol;
    }

    public GraphData<N> edgeStartSymbol(PointSymbol symbol) {
        this.edgeStartSymbol = symbol == null ? new PointSymbol(PointSymbolType.NONE) : symbol;
        return this;
    }

    public final PointSymbol getEdgeEndSymbol() {
        return this.edgeEndSymbol;
    }

    public GraphData<N> edgeEndSymbol(PointSymbol symbol) {
        this.edgeEndSymbol = symbol == null ? new PointSymbol(PointSymbolType.NONE) : symbol;
        return this;
    }

    public void setEdgeEndSymbol(PointSymbol symbol) {
        this.edgeEndSymbol = symbol == null ? new PointSymbol(PointSymbolType.NONE) : symbol;
    }

    @SafeVarargs
    public final void addNode(N ... nodes) {
        if (nodes != null) {
            for (N node : nodes) {
                if (node == null) continue;
                this.nodes.add(node);
            }
        }
    }

    @SafeVarargs
    public final GraphData<N> node(N ... nodes) {
        this.addNode((Node[])nodes);
        return this;
    }

    private int indexOf(Category category) {
        int i;
        if (category == null) {
            category = this.defaultCategory;
        }
        if ((i = this.categories.indexOf(category)) < 0) {
            this.categories.add(category);
            i = this.categories.size() - 1;
        }
        return i;
    }

    void encodeJSON(StringBuilder sb) {
        this.nodes.forEach(n -> this.indexOf(n.category));
        if (this.textLabel != null) {
            ComponentPart.addComma(sb);
            sb.append("\"label\":{");
            this.textLabel.encodeJSON(sb);
            sb.append("}");
        }
        ComponentPart.encode(sb, "layout", (Object)this.getLayout());
        ComponentPart.encode(sb, "roam", this.isRoam());
        ComponentPart.encode(sb, "draggable", this.isDraggable());
        ComponentPart.encode(sb, "autoCurveness", this.isAutoCurveness());
        Offset center = this.getCenter(false);
        if (center != null) {
            center.encodeJSON("center", sb);
        }
        sb.append(String.format(",\"edgeSymbol\": [%s, %s]", this.edgeStartSymbol.getType().toString(), this.edgeEndSymbol.getType().toString()));
        String s = this.edgeStartSymbol.size;
        if (s != null && !s.isEmpty()) {
            sb.append(",\"edgeSymbolSize\":").append(this.edgeStartSymbol.size);
        }
        if (this.force != null) {
            sb.append(",\"force\":");
            this.force.encodeJSON(sb);
        }
        AtomicBoolean first = new AtomicBoolean(true);
        sb.append(",\"categories\":[");
        first.set(true);
        this.categories.forEach(c -> {
            if (first.get()) {
                first.set(false);
            } else {
                sb.append(",");
            }
            c.encodeJSON(sb);
        });
        sb.append("],\"links\":[");
        first.set(true);
        this.nodes.forEach(n -> n.streamEdges().forEach(e -> {
            if (first.get()) {
                first.set(false);
            } else {
                sb.append(",");
            }
            e.encodeJSON(sb);
        }));
        sb.append("]");
    }

    public final Edge connect(N source, N target) {
        return ((Node)source).connectTo((Node)target);
    }

    public final Edge connectFromLastNode(N target) {
        N last = this.getLastNode();
        return last == null ? null : ((Node)last).connectTo((Node)target);
    }

    public final Edge connectToLastNode(N source) {
        N last = this.getLastNode();
        return last == null ? null : ((Node)source).connectTo((Node)last);
    }

    public final N getLastNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return (N)((Node)this.nodes.getLast());
    }

    public final N getFirstNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return (N)((Node)this.nodes.getFirst());
    }

    public final N getNode(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return (N)((Node)this.nodes.get(index));
    }

    public final N getNode(String name) {
        return (N)((Node)this.nodes.stream().filter(n -> n.getName() != null && n.getName().equals(name)).findFirst().orElse(null));
    }

    public final int nodeCount() {
        return this.nodes.size();
    }

    public final Stream<N> nodes() {
        return this.nodes.stream();
    }

    public static class Category
    extends PointSymbol {
        private final String name;

        public Category(String name) {
            this.name = name;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append("{");
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "name", this.name);
            sb.append("}");
        }
    }

    public static enum Layout {
        FORCE,
        CIRCULAR,
        NONE;


        public String toString() {
            return "\"" + super.toString().toLowerCase() + "\"";
        }
    }

    private class NodeData
    extends BasicDataProvider<N> {
        private NodeData() {
        }

        @Override
        public Stream<N> stream() {
            return GraphData.this.nodes();
        }

        @Override
        public void encode(StringBuilder sb, Node value) {
            value.encodeJSON(GraphData.this, sb);
        }
    }

    private class InternalNodeData
    extends BasicInternalDataProvider<N> {
        private InternalNodeData() {
        }

        @Override
        public Stream<N> stream() {
            return GraphData.this.nodes();
        }

        @Override
        public void encode(StringBuilder sb, Node value) {
            value.encodeJSON(GraphData.this, sb);
        }
    }

    public static class Force
    implements ComponentProperty {
        private Layout initialLayout = null;
        private int repulsion = 50;
        private double gravity = 0.1;
        private double friction = 0.6;
        private double edgeLength = 30.0;
        private boolean layoutAnimation = true;

        public Layout getInitialLayout() {
            return this.initialLayout;
        }

        public Force initialLayout(Layout initialLayout) {
            this.initialLayout = initialLayout;
            return this;
        }

        public void setInitialLayout(Layout initialLayout) {
            this.initialLayout = initialLayout;
        }

        public int getRepulsion() {
            return this.repulsion;
        }

        public Force repulsion(int repulsion) {
            this.repulsion = repulsion;
            return this;
        }

        public void setRepulsion(int repulsion) {
            this.repulsion = repulsion;
        }

        public double getGravity() {
            return this.gravity;
        }

        public Force gravity(double gravity) {
            this.gravity = gravity;
            return this;
        }

        public void setGravity(double gravity) {
            this.gravity = gravity;
        }

        public double getFriction() {
            return this.friction;
        }

        public Force friction(double friction) {
            this.friction = friction;
            return this;
        }

        public void setFriction(double friction) {
            this.friction = friction;
        }

        public double getEdgeLength() {
            return this.edgeLength;
        }

        public Force edgeLength(double edgeLength) {
            this.edgeLength = edgeLength;
            return this;
        }

        public void setEdgeLength(double edgeLength) {
            this.edgeLength = edgeLength;
        }

        public boolean isLayoutAnimation() {
            return this.layoutAnimation;
        }

        public Force layoutAnimation(boolean layoutAnimation) {
            this.layoutAnimation = layoutAnimation;
            return this;
        }

        public void setLayoutAnimation(boolean layoutAnimation) {
            this.layoutAnimation = layoutAnimation;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append("{");
            Layout layout = this.getInitialLayout();
            if (layout != null) {
                ComponentPart.encode(sb, "initialLayout", (Object)layout);
            }
            ComponentPart.encode(sb, "repulsion", this.getRepulsion());
            ComponentPart.encode(sb, "gravity", this.getGravity());
            ComponentPart.encode(sb, "friction", this.getFriction());
            ComponentPart.encode(sb, "edgeLength", this.getEdgeLength());
            ComponentPart.encode(sb, "layoutAnimation", this.isLayoutAnimation());
            sb.append('}');
        }
    }

    public static abstract class Node
    implements ComponentPart {
        private final long id = ID.newID();
        protected String name;
        private final List<Edge> edges = new ArrayList<Edge>();
        Category category;

        public Category getCategory() {
            return this.category;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public Edge connectTo(Node target) {
            if (target == null) {
                return null;
            }
            Edge edge = this.edges.stream().filter(e -> e.getDestinationNode() == target).findFirst().orElse(null);
            if (edge != null) {
                return edge;
            }
            edge = new Edge(this, target);
            this.edges.add(edge);
            return edge;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public final long getId() {
            return this.id;
        }

        @Override
        public void setSerial(int serial) {
        }

        @Override
        public int getSerial() {
            return 0;
        }

        @Override
        public void validate() throws ChartException {
        }

        public final Stream<Edge> streamEdges() {
            return this.edges.stream();
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            ComponentPart.encode(sb, "id", "" + this.id);
            if (this.name != null && !this.name.isEmpty()) {
                ComponentPart.encode(sb, "name", this.name);
            }
        }

        void encodeJSON(GraphData<?> chart, StringBuilder sb) {
            sb.append("{");
            this.encodeJSON(sb);
            ComponentPart.encode(sb, "category", chart.indexOf(this.category));
            sb.append("}");
        }
    }

    public static class Edge
    extends LineStyle {
        private final long id = ID.newID();
        private final Node sourceNode;
        private final Node destinationNode;

        private Edge(Node sourceNode, Node destinationNode) {
            this.sourceNode = sourceNode;
            this.destinationNode = destinationNode;
        }

        public Edge connectTo(Node target) {
            return this.destinationNode.connectTo(target);
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append('{');
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "id", "" + this.id);
            ComponentPart.encode(sb, "source", "" + this.sourceNode.id);
            ComponentPart.encode(sb, "target", "" + this.destinationNode.id);
            sb.append('}');
        }

        public Node getSourceNode() {
            return this.sourceNode;
        }

        public Node getDestinationNode() {
            return this.destinationNode;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Edge)) return false;
            Edge e = (Edge)obj;
            if (e.id != this.id) return false;
            return true;
        }
    }

    public static class ValueNode
    extends Node {
        private Number value;

        public ValueNode(Number value) {
            this.value = value;
        }

        public Number getValue() {
            return this.value;
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public ValueNode value(Number value) {
            this.value = value;
            return this;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "value", this.value);
        }
    }

    public static class XYNode
    extends Node {
        private double x;
        private double y;

        public XYNode(String name) {
            this(name, null);
        }

        public XYNode(String name, Category category) {
            this(name, 0.0, 0.0, category);
        }

        public XYNode(String name, double x, double y) {
            this(name, x, y, null);
        }

        public XYNode(String name, double x, double y, Category category) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.setCategory(category);
        }

        public double getX() {
            return this.x;
        }

        public Node x(double x) {
            this.x = x;
            return this;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public Node y(double y) {
            this.y = y;
            return this;
        }

        public void setY(double y) {
            this.y = y;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "x", this.x);
            ComponentPart.encode(sb, "y", this.y);
        }
    }
}

