/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.Color;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.DataType;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.PolarProperty;
import com.storedobject.chart.SelfPositioningChart;
import com.storedobject.chart.VisiblePart;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class GaugeChart
extends SelfPositioningChart
implements HasPolarProperty {
    private int startAngle = Integer.MIN_VALUE;
    private int endAngle = Integer.MIN_VALUE;
    private int divisions = Integer.MIN_VALUE;
    private Number min = Integer.MIN_VALUE;
    private Number max = Integer.MIN_VALUE;
    private PolarProperty polarProperty;
    private final NeedleData data;
    private AxisLine axisLine;
    private boolean showNeedle = true;
    private boolean showProgress = false;

    public GaugeChart() {
        this(1);
    }

    public GaugeChart(String valueName) {
        this(1);
        this.data.needles[0].setName(valueName);
    }

    public GaugeChart(int needles) {
        this(new Needle[needles <= 0 ? 1 : needles]);
    }

    private GaugeChart(Needle[] needles) {
        this(new NeedleData(needles));
        for (int needle = 0; needle < needles.length; ++needle) {
            needles[needle] = new Needle();
        }
    }

    private GaugeChart(NeedleData needleData) {
        super(ChartType.Gauge, false, needleData);
        this.data = needleData;
    }

    public void showNeedle(boolean showNeedle) {
        this.showNeedle = showNeedle;
        if (!showNeedle) {
            this.showProgress = true;
        }
    }

    public void showProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.data;
    }

    public void setValue(Number value) {
        this.setValue(value, 0);
    }

    public Number getValue() {
        return this.data.needles[0].getValue();
    }

    public void setValue(Number value, int needle) {
        if (needle >= 0 && needle < this.data.needles.length) {
            this.data.needles[needle].setValue(value);
        }
    }

    public Number getValue(int needle) {
        return needle >= 0 && needle < this.data.needles.length ? (Number)this.data.needles[needle].getValue() : (Number)null;
    }

    public int getNumberOfNeedles() {
        return this.data.needles.length;
    }

    @Override
    protected String getLabelName() {
        return "axisLabel";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        String f;
        Chart.Label label = this.getLabel(false);
        if (label != null) {
            label.chart = this;
        }
        String formatter = label == null ? null : label.getFormatter();
        String string = f = formatter == null ? null : label.getFormatterValue();
        if (formatter != null) {
            label.setFormatter(null);
        }
        super.encodeJSON(sb);
        ComponentPart.encode(sb, null, this.polarProperty);
        this.encode(sb, "startAngle", this.startAngle);
        this.encode(sb, "endAngle", this.endAngle);
        this.encode(sb, "min", this.min);
        this.encode(sb, "max", this.max);
        this.encode(sb, "splitNumber", this.divisions);
        sb.append(",\"detail\":{\"fontSize\":12,\"valueAnimation\":true,\"color\":\"auto\"");
        if (label != null && f != null) {
            sb.append(",\"formatter\":").append(ComponentPart.escape(f));
        }
        sb.append('}');
        if (formatter != null) {
            label.setFormatter(formatter);
        }
        ComponentPart.encode(sb, "axisLine", this.axisLine);
        sb.append(",\"progress\":{\"show\":").append(this.showProgress).append("},\"pointer\":{\"show\":").append(this.showNeedle).append(",\"itemStyle\":{\"color\":\"auto\"}}");
    }

    private void encode(StringBuilder sb, String name, Number value) {
        if (value.intValue() == Integer.MIN_VALUE) {
            return;
        }
        ComponentPart.addComma(sb);
        ComponentPart.encode(sb, name, value);
    }

    @Override
    public final PolarProperty getPolarProperty(boolean create) {
        if (this.polarProperty == null && create) {
            this.polarProperty = new PolarProperty();
        }
        return this.polarProperty;
    }

    @Override
    public final void setPolarProperty(PolarProperty polarProperty) {
        this.polarProperty = polarProperty;
    }

    public void setStartAngle(int startAngle) {
        this.startAngle = startAngle;
    }

    public void setEndAngle(int endAngle) {
        this.endAngle = endAngle;
    }

    public void setDivisions(int divisions) {
        this.divisions = divisions;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void addDialZone(int percentage, AbstractColor color) {
        if (percentage <= 0) {
            return;
        }
        if (color == null) {
            color = Color.TRANSPARENT;
        }
        this.getAxisLine((boolean)true).style.addZone(percentage, color);
    }

    public AxisLine getAxisLine(boolean create) {
        if (this.axisLine == null && create) {
            this.axisLine = new AxisLine();
        }
        return this.axisLine;
    }

    public Chart.Label getAxisLabel(boolean create) {
        return this.getLabel(create);
    }

    private static class NeedleData
    implements AbstractDataProvider<Needle> {
        private final Needle[] needles;
        private int serial = -1;

        private NeedleData(Needle[] needles) {
            this.needles = needles;
        }

        @Override
        public Stream<Needle> stream() {
            return Stream.of(this.needles);
        }

        @Override
        public DataType getDataType() {
            return DataType.OBJECT;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public void encode(StringBuilder sb, Needle value) {
            value.encodeJSON(sb);
        }
    }

    public static class Needle
    implements ComponentProperty {
        private Number value = 0;
        private String name;

        private Needle() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append("{\"value\":").append(this.value).append(",\"name\":").append(ComponentPart.escape(this.name)).append('}');
        }

        public Number getValue() {
            return this.value;
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class AxisLine
    extends VisiblePart {
        private boolean roundCap = false;
        private final AxisLineStyle style = new AxisLineStyle();

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.encode(sb, "roundCap", this.roundCap);
            ComponentPart.encode(sb, "lineStyle", this.style);
        }

        public void roundCap(boolean roundCap) {
            this.roundCap = roundCap;
        }

        public final LineStyle getStyle() {
            return this.style;
        }
    }

    private static class AxisLineStyle
    extends LineStyle {
        private final Map<Integer, AbstractColor> zones = new TreeMap<Integer, AbstractColor>();

        private AxisLineStyle() {
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            if (this.zones.isEmpty()) {
                return;
            }
            ComponentPart.addComma(sb);
            sb.append("\"color\":[");
            AtomicBoolean first = new AtomicBoolean(true);
            this.zones.keySet().forEach(k -> {
                if (first.get()) {
                    first.set(false);
                } else {
                    sb.append(',');
                }
                sb.append('[').append((double)k.intValue() / 100.0).append(',').append(this.zones.get(k)).append(']');
            });
            sb.append(']');
        }

        void addZone(int zone, AbstractColor color) {
            zone = Math.max(0, zone);
            zone = Math.min(zone, 100);
            this.zones.put(zone, color);
        }
    }
}

