/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import java.time.LocalDate;
import java.time.LocalDateTime;

public enum DataType {
    NUMBER("value", Number.class),
    CATEGORY("category", String.class),
    DATE("time", LocalDate.class),
    TIME("time", LocalDateTime.class),
    LOGARITHMIC("log", Number.class),
    OBJECT("value", Object.class);

    private final String name;
    private final Class<?> type;

    private DataType(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    public final Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "\"" + this.name + "\"";
    }

    public String encode(Object value) {
        if (this == NUMBER) {
            return value.toString();
        }
        return "\"" + String.valueOf(value) + "\"";
    }

    public static DataType guessType(Object value) {
        if (value instanceof String) {
            return CATEGORY;
        }
        if (value instanceof LocalDateTime) {
            return TIME;
        }
        if (value instanceof LocalDate) {
            return DATE;
        }
        if (value instanceof Number) {
            return NUMBER;
        }
        return OBJECT;
    }
}

