/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.CategoryData;
import com.storedobject.chart.CategoryDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Data;
import com.storedobject.chart.DataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DataMatrix {
    private final List<Data> dataList = new ArrayList<Data>();
    private final List<DataProvider> rowData = new ArrayList<DataProvider>();
    private final List<DataProvider> columnData = new ArrayList<DataProvider>();
    private String name;
    private String columnName;
    private String rowName;
    private CategoryData columnNames;
    private CategoryData rowNames;
    private CategoryDataProvider columnNameGenerator;
    private CategoryDataProvider rowNameGenerator;

    public DataMatrix(Data ... data) {
        this((String)null, data);
    }

    public DataMatrix(String name, Data ... data) {
        this.setName(name);
        this.addRow(data);
    }

    public void addRow(Data ... data) {
        if (data != null) {
            for (Data d : data) {
                if (d == null) continue;
                this.dataList.add(d);
            }
        }
    }

    public void addRow(Number ... data) {
        if (data != null && data.length > 0) {
            this.dataList.add(new Data(data));
        }
    }

    public void addRow(double[] data) {
        if (data != null && data.length > 0) {
            this.dataList.add(new Data(data));
        }
    }

    public void insertRow(int index, Data ... data) {
        if (data != null) {
            for (Data d : data) {
                if (d == null) continue;
                this.dataList.add(index, d);
            }
        }
    }

    public void insertRow(int index, Number ... data) {
        if (data != null && data.length > 0) {
            this.dataList.add(index, new Data(data));
        }
    }

    public void insertRow(int index, double[] data) {
        if (data != null && data.length > 0) {
            this.dataList.add(index, new Data(data));
        }
    }

    public void removeRow(Data ... data) {
        if (data != null) {
            for (Data d : data) {
                if (d == null) continue;
                this.dataList.remove(d);
            }
        }
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.dataList.size()) {
            this.dataList.remove(rowIndex);
        }
    }

    public int getRowCount() {
        return this.dataList.size();
    }

    public int getColumnCount() {
        if (this.dataList.isEmpty()) {
            return 0;
        }
        int c = Integer.MAX_VALUE;
        for (Data d : this.dataList) {
            c = Math.min(d.size(), c);
        }
        return c;
    }

    public void setColumnNames(String ... columnNames) {
        this.columnNames = new CategoryData(columnNames);
    }

    public void setColumnNames(CategoryData columnNames) {
        this.columnNames = columnNames;
    }

    public void setRowNames(String ... rowNames) {
        this.rowNames = new CategoryData(rowNames);
    }

    public void setRowNames(CategoryData rowNames) {
        this.rowNames = rowNames;
    }

    public CategoryDataProvider getColumnNames() {
        return this.getColumnNames(-1);
    }

    public CategoryDataProvider getColumnNames(int limit) {
        if (this.columnNameGenerator == null) {
            this.columnNameGenerator = new ColumnNames(limit);
        }
        return this.columnNameGenerator;
    }

    public CategoryDataProvider getRowNames() {
        return this.getRowNames(-1);
    }

    public CategoryDataProvider getRowNames(int limit) {
        if (this.rowNameGenerator == null) {
            this.rowNameGenerator = new RowNames(limit);
        }
        return this.rowNameGenerator;
    }

    public DataProvider getRow(int row) {
        return this.getRow(row, -1);
    }

    public DataProvider getRow(int row, int limit) {
        if (row >= 0 && row <= this.dataList.size()) {
            if (row < this.rowData.size()) {
                return this.rowData.get(row);
            }
            if (row >= this.dataList.size()) {
                return null;
            }
            while (this.rowData.size() <= row) {
                this.rowData.add(new RowData(this.rowData.size(), limit));
            }
            return this.rowData.get(this.rowData.size() - 1);
        }
        return null;
    }

    public DataProvider getColumn(int column) {
        return this.getColumn(column, -1);
    }

    public DataProvider getColumn(int column, int limit) {
        if (column < 0) {
            return null;
        }
        if (column < this.columnData.size()) {
            return this.columnData.get(column);
        }
        if (column >= this.getColumnCount()) {
            return null;
        }
        while (this.columnData.size() <= column) {
            this.columnData.add(new ColumnData(this.columnData.size(), limit));
        }
        return this.columnData.get(this.columnData.size() - 1);
    }

    public String getRowName(int rowIndex) {
        Object name = null;
        if (rowIndex >= 0) {
            if (this.rowNames != null && this.rowNames.size() > rowIndex) {
                name = (String)this.rowNames.get(rowIndex);
            } else if (this.dataList.size() > rowIndex) {
                name = this.dataList.get(rowIndex).getName();
            }
        }
        return name == null ? "Row " + (rowIndex + 1) : name;
    }

    public String getColumnName(int columnIndex) {
        Object name = null;
        if (columnIndex >= 0 && this.columnNames != null && this.columnNames.size() > columnIndex) {
            name = (String)this.columnNames.get(columnIndex);
        }
        return name == null ? "Column " + (columnIndex + 1) : name;
    }

    public String getColumnDataName() {
        return this.columnName;
    }

    public void setColumnDataName(String columnName) {
        this.columnName = columnName;
    }

    public String getRowDataName() {
        return this.rowName;
    }

    public void setRowDataName(String rowName) {
        this.rowName = rowName;
    }

    public String getName() {
        return this.name == null ? "Data" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class ColumnNames
    extends BaseData
    implements CategoryDataProvider {
        private final int limit;

        private ColumnNames(int limit) {
            this.limit = limit;
        }

        @Override
        public Stream<String> stream() {
            int l = this.limit;
            l = l <= 0 ? DataMatrix.this.getColumnCount() : Math.min(l, DataMatrix.this.getColumnCount());
            return Stream.generate(new ColumnNameGenerator()).limit(l);
        }

        @Override
        public String getName() {
            String name = DataMatrix.this.columnName;
            if (name == null && DataMatrix.this.columnNames != null) {
                name = DataMatrix.this.columnNames.getName();
            }
            if (name == null) {
                name = "Column Data";
            }
            return name;
        }

        @Override
        public void validate() {
        }

        private class ColumnNameGenerator
        implements Supplier<String> {
            private int index = 0;

            private ColumnNameGenerator() {
            }

            @Override
            public String get() {
                return DataMatrix.this.getColumnName(this.index++);
            }
        }
    }

    private class RowNames
    extends BaseData
    implements CategoryDataProvider {
        private final int limit;

        private RowNames(int limit) {
            this.limit = limit;
        }

        @Override
        public Stream<String> stream() {
            int l = this.limit;
            l = l <= 0 ? DataMatrix.this.getRowCount() : Math.min(l, DataMatrix.this.getRowCount());
            return Stream.generate(new RowNameGenerator()).limit(l);
        }

        @Override
        public String getName() {
            String name = DataMatrix.this.rowName;
            if (name == null && DataMatrix.this.rowNames != null) {
                name = DataMatrix.this.rowNames.getName();
            }
            if (name == null) {
                name = "Row Data";
            }
            return name;
        }

        @Override
        public void validate() {
        }

        private class RowNameGenerator
        implements Supplier<String> {
            private int row = 0;

            private RowNameGenerator() {
            }

            @Override
            public String get() {
                return DataMatrix.this.getRowName(this.row++);
            }
        }
    }

    private class RowData
    extends BaseData
    implements DataProvider {
        private final int row;
        private final int limit;

        private RowData(int row, int limit) {
            this.row = row;
            this.limit = limit;
        }

        @Override
        public Stream<Number> stream() {
            Stream<Number> s = DataMatrix.this.dataList.get(this.row).stream();
            return this.limit <= 0 ? s : s.limit(this.limit);
        }

        @Override
        public String getName() {
            return DataMatrix.this.getRowName(this.row);
        }

        @Override
        public void validate() {
        }
    }

    private class ColumnData
    extends BaseData
    implements DataProvider {
        private final int index;
        private final int limit;

        private ColumnData(int index, int limit) {
            this.index = index;
            this.limit = limit;
        }

        @Override
        public String getName() {
            return DataMatrix.this.getColumnName(this.index);
        }

        @Override
        public Stream<Number> stream() {
            int l = this.limit;
            l = l <= 0 ? DataMatrix.this.dataList.size() : Math.min(l, DataMatrix.this.dataList.size());
            return Stream.generate(new Generator()).limit(l);
        }

        @Override
        public void validate() throws ChartException {
            if (this.index < 0) {
                throw new ChartException("Index can't be negative");
            }
            for (Data data : DataMatrix.this.dataList) {
                if (this.index < data.size()) continue;
                Object m = data.getName();
                if (m == null) {
                    m = "Data[" + DataMatrix.this.dataList.indexOf(data) + "]";
                }
                throw new ChartException("No data at index " + this.index + " in " + (String)m);
            }
        }

        private class Generator
        implements Supplier<Number> {
            private int row = 0;

            private Generator() {
            }

            @Override
            public Number get() {
                if (this.row >= DataMatrix.this.dataList.size()) {
                    return null;
                }
                return (Number)DataMatrix.this.dataList.get(this.row++).get(ColumnData.this.index);
            }
        }
    }

    private static abstract class BaseData {
        private int serial = -1;

        private BaseData() {
        }

        public long getId() {
            return -1L;
        }

        public final int getSerial() {
            return this.serial;
        }

        public final void setSerial(int serial) {
            this.serial = serial;
        }
    }
}

