/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.SOChart;

public final class DataChannel {
    private final SOChart soChart;
    private final AbstractDataProvider<?>[] dataProviders;

    public DataChannel(SOChart soChart, AbstractDataProvider<?> ... dataProviders) {
        assert (soChart != null);
        assert (dataProviders != null && dataProviders.length > 0);
        this.soChart = soChart;
        this.dataProviders = dataProviders;
    }

    public void append(Object ... data) throws ChartException {
        this.process("append", data);
    }

    public void appendEncoded(Object ... data) {
        this.processEncoded("append", data);
    }

    public void push(Object ... data) throws ChartException {
        this.process("push", data);
    }

    private void process(String command, Object ... data) throws ChartException {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            for (int i = 0; i < this.dataProviders.length; ++i) {
                StringBuilder sb = new StringBuilder();
                AbstractDataProvider<?> dp = this.dataProviders[i];
                dp.encode(sb, data[i]);
                data[i] = sb;
            }
        }
        catch (Throwable e) {
            throw new ChartException("Incompatible data");
        }
        this.processEncoded(command, data);
    }

    public void pushEncoded(Object ... data) {
        this.processEncoded("push", data);
    }

    private void processEncoded(String command, Object ... data) {
        if (data == null || data.length == 0) {
            return;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder("{\"d\":{");
        boolean first = true;
        for (AbstractDataProvider<?> d : this.dataProviders) {
            if (i >= this.dataProviders.length) break;
            if (d.getSerial() > 0) {
                if (data[i] == null) {
                    data[i] = "-";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append("\"d").append(d.getSerial()).append("\":").append(data[i]);
            }
            ++i;
        }
        sb.append("}}");
        this.soChart.updateData(sb.toString(), command);
    }

    public void reset() {
        StringBuilder sb = new StringBuilder("{\"d\":[");
        boolean first = true;
        for (AbstractDataProvider<?> d : this.dataProviders) {
            if (d.getSerial() <= 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(d.getSerial());
        }
        sb.append("]}");
        this.soChart.updateData(sb.toString(), "reset");
    }
}

