/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentProperty;

public interface ComponentPart
extends ComponentProperty {
    default public void setRenderingIndex(int index) {
    }

    default public int getRenderingIndex() {
        return -1;
    }

    public long getId();

    public void setSerial(int var1);

    public int getSerial();

    public static void encode(StringBuilder sb, String name, Object value) {
        if (value == null && name == null) {
            return;
        }
        if (value instanceof ComponentProperty) {
            ComponentPart.addComma(sb);
            if (name != null) {
                sb.append('\"').append(name).append("\":{");
            }
            ((ComponentProperty)value).encodeJSON(sb);
            if (name != null) {
                sb.append('}');
            }
            return;
        }
        if (name != null && value != null) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(name).append("\":").append(ComponentPart.escape(value));
        }
    }

    public static void addComma(StringBuilder sb) {
        int len = sb.length();
        if (len == 0) {
            return;
        }
        while (len > 0) {
            char c;
            if ((c = sb.charAt(--len)) == ' ' || c == '\n') continue;
            if (c == '{' || c == '[' || c == ',') break;
            sb.append(',');
            break;
        }
    }

    public static void encodeFunction(StringBuilder sb, String name, String body, String ... params) {
        if (name != null) {
            ComponentPart.addComma(sb);
            sb.append('\"').append(name).append("\":");
        }
        sb.append("{\"function\":{").append("\"params\":[");
        if (params != null && params.length > 0) {
            boolean first = true;
            for (String p : params) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\"').append(p).append('\"');
            }
        }
        if (!((String)body).endsWith(";")) {
            body = (String)body + ";";
        }
        sb.append("],\"body\":").append(ComponentPart.escape(body)).append("}}");
    }

    public static String encodeFunction(String body, String ... params) {
        StringBuilder s = new StringBuilder("{\"function\":{\"params\":\"");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(params[i]);
        }
        s.append("\",\"body\":").append(ComponentPart.escape(body)).append("}}");
        return s.toString();
    }

    public static void removeComma(StringBuilder sb) {
        for (int len = sb.length() - 1; len >= 0 && sb.charAt(len) == ','; --len) {
            sb.setCharAt(len, ' ');
        }
    }

    public void validate() throws ChartException;

    default public String className() {
        String name = this.getName();
        return ComponentPart.className(this.getClass()) + (String)(name == null ? "" : " (" + name + ")");
    }

    default public String getName() {
        return null;
    }

    default public void setName(String name) {
    }

    public static String className(Class<?> anyClass) {
        String cName = anyClass.getName();
        return Chart.name(cName.substring(cName.lastIndexOf(46) + 1)).replace('$', '/');
    }

    public static String escape(Object any) {
        String string;
        String string2 = string = any == null ? "" : any.toString();
        if (string == null) {
            string = "";
        }
        if (any instanceof Number || any instanceof Boolean) {
            return any.toString();
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("[") && string.endsWith("]")) {
            return string;
        }
        if (string.contains("\"")) {
            string = string.replace("\"", "\\\"");
        }
        if (string.contains("\n")) {
            string = string.replace("\n", "\\n");
        }
        return "\"" + string + "\"";
    }
}

