/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractPart;
import com.storedobject.chart.Animation;
import com.storedobject.chart.Axis;
import com.storedobject.chart.CategoryDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.HasAnimation;
import com.storedobject.chart.HasData;
import com.storedobject.chart.HasEmphasis;
import com.storedobject.chart.ItemStyle;
import com.storedobject.chart.MarkArea;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.Size;
import com.storedobject.chart.Tooltip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Chart
extends AbstractPart
implements Component,
HasData,
HasAnimation,
HasEmphasis {
    List<Axis> axes;
    private ChartType type = ChartType.Line;
    private String custom;
    private Label label;
    private ItemStyle itemStyle;
    private String name;
    CoordinateSystem coordinateSystem;
    private AbstractDataProvider<?>[] data;
    private AbstractColor[] colors;
    private final Map<Class<? extends ComponentProperty>, ComponentProperty> propertyMap = new HashMap<Class<? extends ComponentProperty>, ComponentProperty>();
    private final Map<Class<? extends ComponentProperty>, String> propertyNameMap = new HashMap<Class<? extends ComponentProperty>, String>();
    private MarkArea markArea;
    private Animation animation;
    private Emphasis emphasis;
    private SOChart soChart;

    public Chart() {
        this(ChartType.Line, new AbstractDataProvider[0]);
    }

    public Chart(AbstractDataProvider<?> ... data) {
        this((ChartType)null, data);
    }

    public Chart(ChartType type, AbstractDataProvider<?> ... data) {
        this.setType(type);
        this.data = data;
    }

    public void setData(AbstractDataProvider<?> ... data) {
        this.data = data;
    }

    public final AbstractDataProvider<?>[] getData() {
        return this.data;
    }

    public void setCustomRenderer(String renderer) {
        this.custom = renderer;
    }

    protected String typeValue() {
        return this.custom == null ? this.type.getType() : "custom";
    }

    protected AbstractDataProvider<?> dataToEmbed() {
        return null;
    }

    protected AbstractDataProvider<?> dataValue() {
        AbstractDataProvider<?> d = this.dataToEmbed();
        if (d == null) {
            if (this.data.length > 1) {
                d = this.data[1];
            } else if (this.data.length > 0) {
                d = this.data[0];
            }
        }
        return d;
    }

    protected AbstractDataProvider<?> mainData() {
        for (AbstractDataProvider<?> d : this.getData()) {
            if (d == null) continue;
            return d;
        }
        return this.dataValue();
    }

    protected int dataValueIndex() {
        return -1;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        AbstractDataProvider<?> dataToEmbed;
        super.encodeJSON(sb);
        if (this.colors != null) {
            ComponentPart.addComma(sb);
            sb.append("\"color\":[");
            for (int i = 0; i < this.colors.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.colors[i]);
            }
            sb.append(']');
        }
        if ((dataToEmbed = this.dataToEmbed()) != null) {
            ComponentPart.encode(sb, "data", dataToEmbed.getSerial());
        }
        ComponentPart.encode(sb, "type", this.typeValue());
        if (this.custom != null) {
            ComponentPart.encode(sb, "renderItem", this.custom);
        }
        if (this.coordinateSystem != null) {
            if (this.coordinateSystem.axes != this.axes) {
                if (this.axes != null && !this.axes.isEmpty()) {
                    for (Axis a2 : this.axes) {
                        ComponentPart aw = a2.wrap(this.coordinateSystem);
                        ComponentPart.encode(sb, a2.axisName() + "Index", aw.getRenderingIndex());
                    }
                }
            } else {
                HashSet axisClasses = new HashSet();
                this.coordinateSystem.axes.forEach(a -> axisClasses.add(a.getClass()));
                axisClasses.forEach(ac -> this.coordinateSystem.axes((Class<?>)ac).map(a -> a.wrap(this.coordinateSystem)).min(Comparator.comparing(ComponentPart::getSerial)).ifPresent(w -> {
                    Axis.AxisWrapper aw = (Axis.AxisWrapper)w;
                    ComponentPart.encode(sb, aw.axis.axisName() + "Index", aw.getRenderingIndex());
                }));
            }
        }
        if (this.coordinateSystem != null) {
            ComponentPart.encode(sb, "coordinateSystem", this.coordinateSystem.systemName());
        }
        this.propertyMap.values().forEach(p -> ComponentPart.encode(sb, this.getPropertyName((ComponentProperty)p), p));
        if (this.label != null) {
            this.label.chart = this;
            ComponentPart.encode(sb, this.getLabelName(), this.label);
        }
        ComponentPart.encode(sb, "itemStyle", this.itemStyle);
        if (dataToEmbed == null) {
            ComponentPart.addComma(sb);
            sb.append("\"encode\":{");
            String[] axes = null;
            if (this.coordinateSystem != null) {
                axes = this.coordinateSystem.axesData();
            }
            if (axes == null) {
                axes = this.type.getAxes();
            }
            for (int i = 0; i < axes.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('\"').append(axes[i]).append("\":\"d").append(this.data[i].getSerial()).append("\"");
            }
            sb.append('}');
        }
        ComponentPart.encode(sb, "markArea", this.markArea);
    }

    protected String getLabelName() {
        return "label";
    }

    @Override
    public void validate() throws ChartException {
        String[] axes = this.type.getAxes();
        if (this.data == null) {
            throw new ChartException("Data not set for " + this.className());
        }
        if (this.data.length < axes.length) {
            throw new ChartException("Data for " + Chart.name(axes[this.data.length]) + " not set for " + this.className());
        }
        if (this.type.requireCoordinateSystem()) {
            if (this.coordinateSystem == null) {
                throw new ChartException("Coordinate system not set for " + this.className());
            }
            if (this.axes == null || this.axes.isEmpty()) {
                this.axes = this.coordinateSystem.axes;
            }
            if (this.coordinateSystem.axes != this.axes) {
                for (Axis a : this.axes) {
                    if (this.coordinateSystem.axes.contains(a)) continue;
                    String name = a.getName();
                    if (name == null) {
                        name = ComponentPart.className(a.getClass());
                    }
                    throw new ChartException("Axis " + name + " doesn't belong to the coordinate system of this chart - " + this.getName());
                }
            }
        }
        if (this.coordinateSystem != null && this.coordinateSystem.axes != this.axes) {
            for (Axis a : this.axes) {
                if (this.axes.stream().filter(ax -> ax.getClass() == a.getClass()).count() <= 1L) continue;
                String name = a.getName();
                if (name == null) {
                    name = ComponentPart.className(a.getClass());
                }
                throw new ChartException("Multiple axes of the same type found (" + name + ") for this chart - " + this.getName());
            }
        }
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    private String getPropertyName(ComponentProperty property) {
        Object name = this.propertyNameMap.get(property.getClass());
        if (name == null) {
            name = property.getClass().getName();
            name = ((String)name).substring(((String)name).lastIndexOf(46) + 1);
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        return name;
    }

    <P extends ComponentProperty> void setPropertyName(Class<P> propertyClass, String name) {
        this.propertyNameMap.put(propertyClass, name);
    }

    <P extends ComponentProperty> P getProperty(Class<P> propertyClass, boolean create) {
        ComponentProperty property = this.propertyMap.get(propertyClass);
        if (property == null && create) {
            try {
                property = (ComponentProperty)propertyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ignored) {
                return null;
            }
            this.propertyMap.put(propertyClass, property);
        }
        return (P)property;
    }

    void setProperty(ComponentProperty property) {
        this.propertyMap.put(property.getClass(), property);
    }

    String axisName(int axis) {
        return Chart.name(this.type.getAxes()[axis]);
    }

    static String name(String name) {
        if (name.substring(1).equals(name.substring(1).toLowerCase())) {
            return name;
        }
        StringBuilder n = new StringBuilder();
        n.append(Character.toUpperCase(name.charAt(0)));
        name.chars().skip(1L).forEach(c -> {
            if (Character.isUpperCase((char)c)) {
                n.append(' ');
            }
            n.append((char)c);
        });
        return n.toString();
    }

    @Override
    public void addParts(SOChart soChart) {
        this.soChart = soChart;
        if (this.coordinateSystem != null) {
            soChart.addParts(this.coordinateSystem);
            this.coordinateSystem.addParts(soChart);
        } else {
            soChart.addParts(this.data);
        }
        Tooltip tooltip = this.getTooltip(false);
        if (tooltip != null) {
            tooltip.addParts(soChart);
        }
        if (this.markArea != null) {
            soChart.addParts(this.markArea.data);
        }
        if (this.label != null && this.label.labels != null) {
            soChart.addData(this.label.labels);
        }
    }

    @Override
    public void declareData(Set<AbstractDataProvider<?>> dataSet) {
        Tooltip tooltip;
        dataSet.addAll(Arrays.asList(this.data));
        AbstractDataProvider<?> d = this.dataToEmbed();
        if (d != null) {
            dataSet.add(d);
        }
        if (this.markArea != null) {
            dataSet.add(this.markArea.data);
        }
        if ((tooltip = this.getTooltip(false)) != null) {
            tooltip.declareData(dataSet);
        }
    }

    public ChartType getType() {
        return this.type;
    }

    public void setType(ChartType type) {
        this.type = type == null ? ChartType.Line : type;
    }

    public Chart plotOn(CoordinateSystem coordinateSystem, Axis ... axes) {
        if (coordinateSystem == null) {
            this.axes = null;
        } else if (this.type.requireCoordinateSystem()) {
            coordinateSystem.add(this);
        }
        if (this.coordinateSystem != null && axes != null && axes.length > 0) {
            this.axes = new ArrayList<Axis>();
            for (Axis a : axes) {
                if (a == null) continue;
                this.axes.add(a);
            }
            this.coordinateSystem.addAxis(axes);
        }
        return this;
    }

    public Chart plotOn(Axis ... axes) {
        if (axes != null && axes.length > 0) {
            this.axes = new ArrayList<Axis>();
            for (Axis a : axes) {
                if (a == null) continue;
                this.axes.add(a);
            }
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name == null || this.name.isEmpty() ? "Chart " + (this.getSerial() + 1) : this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setColors(AbstractColor ... colors) {
        this.colors = colors.length == 0 ? null : colors;
    }

    public Tooltip getTooltip(boolean create) {
        return this.getProperty(Tooltip.class, create);
    }

    public void setTooltip(Tooltip tooltip) {
        this.setProperty(tooltip);
    }

    public final Label getLabel(boolean create) {
        if (this.label == null && create) {
            this.label = new Label();
        }
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Object getMin() {
        AbstractDataProvider<?> d = this.data4MinMax();
        return d == null ? null : d.getMin();
    }

    public Object getMax() {
        AbstractDataProvider<?> d = this.data4MinMax();
        return d == null ? null : d.getMax();
    }

    private AbstractDataProvider<?> data4MinMax() {
        AbstractDataProvider<?> d = this.dataToEmbed();
        if (d != null) {
            return d;
        }
        for (AbstractDataProvider<?> dp : this.data) {
            if (dp instanceof CategoryDataProvider) continue;
            return dp;
        }
        return this.data.length == 0 ? null : (this.data.length == 1 ? this.data[0] : this.data[1]);
    }

    public final ItemStyle getItemStyle(boolean create) {
        if (this.itemStyle == null && create) {
            this.itemStyle = new ItemStyle();
        }
        return this.itemStyle;
    }

    public void setItemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }

    public MarkArea getMarkArea(boolean create) {
        if (this.markArea == null && create) {
            this.markArea = new MarkArea();
        }
        return this.markArea;
    }

    public void setMarkArea(MarkArea markArea) {
        this.markArea = markArea;
    }

    @Override
    public Animation getAnimation(boolean create) {
        if (create && this.animation == null) {
            this.animation = new Animation();
        }
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Emphasis getEmphasis(boolean create) {
        if (this.emphasis == null && create) {
            this.emphasis = new Emphasis();
        }
        return this.emphasis;
    }

    @Override
    public void setEmphasis(com.storedobject.chart.Emphasis emphasis) {
        if (emphasis instanceof Emphasis) {
            Emphasis e;
            this.emphasis = e = (Emphasis)emphasis;
        }
    }

    public static class Label
    extends com.storedobject.chart.Label {
        private AbstractDataProvider<?> labels;
        Chart chart;
        private final LabelPosition position = new LabelPosition();

        public Label() {
            this.formatParser = this::format;
        }

        @Override
        protected String getGapName() {
            return "distance";
        }

        @Override
        public void setFormatter(String formatter) {
            this.labels = null;
            this.formatter = formatter;
        }

        private String format(String f) {
            for (int i = 0; i < this.chart.data.length; ++i) {
                f = f.replace("{" + i + "}", "{@d" + this.chart.data[i].getSerial() + "}");
            }
            SOChart soChart = this.chart.soChart;
            if (soChart != null) {
                for (AbstractDataProvider<?> data : soChart.dataSet()) {
                    f = f.replace("{D:" + data.getName() + "}", "{@d" + data.getSerial() + "}");
                }
            }
            return f.replace("{chart}", "{a}");
        }

        public void setLabelProvider(AbstractDataProvider<?> labels) {
            this.formatter = "";
            this.labels = labels;
        }

        @Override
        String getFormatterValue() {
            if (this.labels != null) {
                this.formatter = "{D:" + this.labels.getName() + "}";
            }
            return super.getFormatterValue();
        }

        public LabelPosition getPosition() {
            return this.position;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(this.position.encode(this.isInside()));
        }
    }

    public static class Emphasis
    extends com.storedobject.chart.Emphasis {
        private FADE_OUT fadeOut;
        private FADE_OUT_SCOPE fadeOutScope;

        public void setFadeOut(FADE_OUT fadeOut) {
            this.fadeOut = fadeOut;
        }

        public void setFadeOutScope(FADE_OUT_SCOPE fadeOutScope) {
            this.fadeOutScope = fadeOutScope;
        }

        @Override
        protected void encodeProperty(StringBuilder sb) {
            super.encodeProperty(sb);
            ComponentPart.encode(sb, "focus", (Object)this.fadeOut);
            ComponentPart.encode(sb, "blurScope", (Object)this.fadeOutScope);
        }

        public static enum FADE_OUT {
            NONE("none"),
            ALL_OTHERS("self"),
            OTHERS("series");

            private final String code;

            private FADE_OUT(String code) {
                this.code = code;
            }

            public String toString() {
                return this.code;
            }
        }

        public static enum FADE_OUT_SCOPE {
            LOCAL("coordinateSystem"),
            CHART("series"),
            GLOBAL("global");

            private final String code;

            private FADE_OUT_SCOPE(String code) {
                this.code = code;
            }

            public String toString() {
                return this.code;
            }
        }
    }

    public static class LabelPosition {
        private boolean left = false;
        private boolean right = false;
        private boolean top = false;
        private boolean bottom = false;
        private boolean center = false;
        private Size x;
        private Size y;

        public void at(Size x, Size y) {
            this.x = x;
            this.y = y;
            this.center = false;
            this.bottom = false;
            this.top = false;
            this.right = false;
            this.left = false;
        }

        public LabelPosition left() {
            this.y = null;
            this.x = null;
            this.left = true;
            this.right = false;
            this.center = false;
            return this;
        }

        public LabelPosition right() {
            this.y = null;
            this.x = null;
            this.left = false;
            this.right = true;
            this.center = false;
            return this;
        }

        public LabelPosition top() {
            this.y = null;
            this.x = null;
            this.top = true;
            this.bottom = false;
            this.center = false;
            return this;
        }

        public LabelPosition bottom() {
            this.y = null;
            this.x = null;
            this.top = false;
            this.bottom = true;
            this.center = false;
            return this;
        }

        public LabelPosition center() {
            this.y = null;
            this.x = null;
            this.top = false;
            this.bottom = false;
            this.center = true;
            return this;
        }

        private boolean set(Size size) {
            switch (size.get()) {
                case -101: {
                    this.left = true;
                    break;
                }
                case -112: 
                case -111: 
                case -102: {
                    this.top = true;
                    break;
                }
                case -103: {
                    this.right = true;
                    break;
                }
                case -113: {
                    this.bottom = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            if (this.center) {
                return "center";
            }
            if (this.x != null && this.y != null) {
                if (this.set(this.x)) {
                    this.x = null;
                }
                if (this.set(this.y)) {
                    this.y = null;
                }
                if (this.x != null && this.y != null) {
                    return "[" + this.x.encode() + "," + this.y.encode() + "]";
                }
            }
            StringBuilder s = new StringBuilder();
            if (this.top) {
                s.append("Top");
            }
            if (this.bottom) {
                s.append("Bottom");
            }
            if (this.left) {
                s.append("Left");
            }
            if (this.right) {
                s.append("Right");
            }
            return s.toString();
        }

        private String encode(boolean inside) {
            Object s = this.toString();
            if (inside) {
                s = "inside" + (String)s;
            }
            if (((String)s).isEmpty()) {
                return s;
            }
            return ",\"position\":\"" + ((String)s).substring(0, 1).toLowerCase() + ((String)s).substring(1) + "\"";
        }
    }
}

