/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Shape;

public class BezierCurve
extends Shape {
    private Shape.Point from;
    private Shape.Point to;
    private Shape.Point cp1;
    private Shape.Point cp2;

    public BezierCurve(Shape.Point from, Shape.Point to, Shape.Point controlPoint) {
        this(from, to, controlPoint, null);
    }

    public BezierCurve(Shape.Point from, Shape.Point to, Shape.Point controlPoint1, Shape.Point controlPoint2) {
        this.from = from;
        this.to = to;
        this.cp1 = controlPoint1;
        this.cp2 = controlPoint2;
    }

    @Override
    protected final String getType() {
        return "bezierCurve";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        sb.append("\"shape\":{");
        BezierCurve.encodePoint(sb, "x1", "y1", this.from);
        BezierCurve.encodePoint(sb, "x2", "y2", this.to);
        BezierCurve.encodePoint(sb, "cpx1", "cpy1", this.cp1);
        BezierCurve.encodePoint(sb, "cpx2", "cpy2", this.cp2);
        sb.append('}');
    }

    public final Shape.Point getFrom() {
        return this.from;
    }

    public void setFrom(Shape.Point from) {
        this.from = from;
    }

    public final Shape.Point getTo() {
        return this.to;
    }

    public void setTo(Shape.Point to) {
        this.to = to;
    }

    public final Shape.Point getControlPoint1() {
        return this.cp1;
    }

    public void setControlPoint1(Shape.Point controlPoint) {
        this.cp1 = controlPoint;
    }

    public final Shape.Point getControlPoint2() {
        return this.cp2;
    }

    public void setControlPoint2(Shape.Point controlPoint) {
        this.cp2 = controlPoint;
    }

    public final Shape.Point getControlPoint() {
        return this.cp1;
    }

    public void setControlPoint(Shape.Point controlPoint) {
        this.cp1 = controlPoint;
    }
}

