/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.CirclePart;

public abstract class ArcPart
extends CirclePart {
    private Number startAngle;
    private Number endAngle;
    private boolean clockwise;
    private Number holeRadius;

    public ArcPart(Number radius, Number startAngle, Number endAngle, boolean clockwise) {
        super(radius);
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.clockwise = clockwise;
    }

    @Override
    protected void encodeShape(StringBuilder sb) {
        super.encodeShape(sb);
        ArcPart.encode(sb, "r0", this.holeRadius);
        ArcPart.encode(sb, "startAngle", ArcPart.rad(this.startAngle));
        ArcPart.encode(sb, "endAngle", ArcPart.rad(this.endAngle));
        ArcPart.encode(sb, "clockwise", this.clockwise);
    }

    private static double rad(Number d) {
        if (d == null) {
            return 0.0;
        }
        return d.doubleValue() * Math.PI / 180.0;
    }

    public Number getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(Number startAngle) {
        this.startAngle = startAngle;
    }

    public final Number getEndAngle() {
        return this.endAngle;
    }

    public void setEndAngle(Number endAngle) {
        this.endAngle = endAngle;
    }

    public final boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public final Number getHoleRadius() {
        return this.holeRadius;
    }

    public void setHoleRadius(Number holeRadius) {
        this.holeRadius = holeRadius;
    }
}

