/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.DataType;

public class AngleAxis
extends Axis {
    private boolean clockwise = true;
    private int startingAngle = 90;

    public AngleAxis(DataType dataType) {
        super(dataType);
    }

    public AngleAxis(AbstractDataProvider<?> data) {
        super(data);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (!this.clockwise) {
            sb.append(",\"clockwise\":false");
        }
        sb.append(",\"startAngle\":").append(this.startingAngle);
    }

    @Override
    ComponentPart wrap(CoordinateSystem coordinateSystem) {
        Axis.AxisWrapper w = (Axis.AxisWrapper)this.wrappers.get(coordinateSystem);
        return w == null ? new AngleAxisWrapper(this, coordinateSystem) : w;
    }

    public void anticlockwise() {
        this.clockwise = false;
    }

    public int getStartingAngle() {
        return this.startingAngle;
    }

    public void setStartingAngle(int startingAngle) {
        this.startingAngle = startingAngle;
    }

    static class AngleAxisWrapper
    extends Axis.AxisWrapper {
        AngleAxisWrapper(Axis axis, CoordinateSystem coordinateSystem) {
            super(axis, coordinateSystem);
        }
    }
}

