/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.Shadow;

public abstract class AbstractStyle
implements ComponentProperty {
    private AbstractColor color;
    private int opacity = -1;
    private Shadow shadow;

    @Override
    public void encodeJSON(StringBuilder sb) {
        if (this.color != null) {
            this.color.encodeJSON(sb);
        }
        AbstractStyle.encode(sb, "opacity", (double)Math.min(100, this.opacity) / 100.0);
        ComponentPart.encode(sb, null, this.shadow);
    }

    static void encode(StringBuilder sb, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number && ((Number)value).intValue() <= 0) {
            return;
        }
        ComponentPart.addComma(sb);
        if (value instanceof LineStyle.Type) {
            value = value.toString().toLowerCase();
        }
        ComponentPart.encode(sb, name, value);
    }

    public final AbstractColor getColor() {
        return this.color;
    }

    public void setColor(AbstractColor color) {
        this.color = color;
    }

    public final Shadow getShadow(boolean create) {
        if (this.shadow == null && create) {
            this.shadow = new Shadow();
        }
        return this.shadow;
    }

    public void setShadow(Shadow shadow) {
        this.shadow = shadow;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }
}

