/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.badge;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.dom.Element;

@JsModule(value="./src/badge/badge.ts")
@Tag(value="tatus-badge")
public class Badge
extends Component
implements HasTheme,
HasTooltip {
    private String text = "";
    private Icon icon;
    private boolean first;
    private String html;

    public Badge() {
    }

    public Badge(String text) {
        this();
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        this.getElement().removeAllChildren();
        this.add((Component)new Span(text));
    }

    public void setVariant(BadgeVariant variant) {
        for (BadgeVariant v : BadgeVariant.values()) {
            if (v.getVariant() == null) continue;
            this.removeThemeName(v.getVariant());
        }
        if (variant != BadgeVariant.NORMAL) {
            this.addThemeName(variant.getVariant());
        }
    }

    public void setPrimary(boolean primary) {
        if (primary) {
            this.addThemeName("primary");
        } else {
            this.removeThemeName("primary");
        }
    }

    public void setPill(boolean pill) {
        if (pill) {
            this.addThemeName("pill");
        } else {
            this.removeThemeName("pill");
        }
    }

    public void setSmall(boolean small) {
        if (small) {
            this.addThemeName("small");
        } else {
            this.removeThemeName("small");
        }
    }

    public void setIcon(Icon icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(Icon icon, boolean first) {
        this.getElement().removeAllChildren();
        this.icon = icon;
        this.first = first;
        if (first) {
            this.add((Component)icon);
            if (this.html != null) {
                this.add((Component)new Html(this.html));
            } else {
                this.add((Component)new Span(this.text));
            }
        } else {
            if (this.html != null) {
                this.add((Component)new Html(this.html));
            } else {
                this.add((Component)new Span(this.text));
            }
            this.add((Component)icon);
        }
    }

    public void setHtml(String html) {
        this.html = html;
        this.getElement().removeAllChildren();
        if (this.first && this.icon != null) {
            this.add((Component)this.icon);
        }
        this.add((Component)new Html(html));
        if (this.icon != null) {
            this.add((Component)this.icon);
        }
    }

    public void setPadding(boolean padding) {
        if (padding) {
            this.addThemeName("badge");
        } else {
            this.removeThemeName("badge");
        }
    }

    void add(Component comp) {
        comp.getElement().setAttribute("slot", "content");
        this.getElement().appendChild(new Element[]{comp.getElement()});
    }

    public static enum BadgeVariant {
        NORMAL(null),
        SUCCESS("success"),
        ERROR("error"),
        WARNING("warning"),
        CONTRAST("contrast");

        private String variant;

        private BadgeVariant(String variant) {
            this.variant = variant;
        }

        public String getVariant() {
            return this.variant;
        }
    }
}

