/*
 * Decompiled with CFR 0.152.
 */
package com.lipisak.vaadin.slidetab;

import com.lipisak.vaadin.slidetab.ScheduleStrategy;
import com.lipisak.vaadin.slidetab.SlideMode;
import com.lipisak.vaadin.slidetab.SlideTab;
import com.lipisak.vaadin.slidetab.SlideTabPosition;
import com.lipisak.vaadin.slidetab.SlideToggleEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlideTabBuilder {
    protected Component content;
    protected SlideMode mode = SlideMode.TOP;
    protected boolean expanded = false;
    protected boolean flowInContent = false;
    protected boolean tabVisible = true;
    protected int tabSize = 40;
    protected List<ComponentEventListener<SlideToggleEvent>> listeners = null;
    protected String caption = null;
    protected SlideTabPosition tabPosition = SlideTabPosition.BEGINNING;
    protected int animationDuration = 500;
    protected List<String> styles = null;
    protected int pixel = -1;
    protected boolean autoCollapseSlider = false;
    protected int zIndex = 1;
    protected ScheduleStrategy scheduleStrategy;

    public SlideTabBuilder(Component content) {
        this.content = content;
    }

    public SlideTabBuilder(Component content, String caption) {
        this.content = content;
        this.caption = caption;
    }

    public SlideTabBuilder mode(SlideMode mode) {
        this.mode = mode;
        return this;
    }

    public SlideTabBuilder expanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public SlideTabBuilder flowInContent(boolean flowInContent) {
        this.flowInContent = flowInContent;
        return this;
    }

    public SlideTabBuilder tabSize(int tabSize) {
        this.tabSize = tabSize;
        return this;
    }

    public SlideTabBuilder listener(ComponentEventListener<SlideToggleEvent> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ComponentEventListener<SlideToggleEvent>>();
        }
        this.listeners.add(listener);
        return this;
    }

    public SlideTabBuilder caption(String caption) {
        this.caption = caption;
        return this;
    }

    public SlideTabBuilder tabPosition(SlideTabPosition tabPosition) {
        this.tabPosition = tabPosition;
        return this;
    }

    public SlideTabBuilder tabVisible(boolean tabVisible) {
        this.tabVisible = tabVisible;
        return this;
    }

    public SlideTabBuilder animationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        return this;
    }

    public SlideTabBuilder style(String ... style) {
        if (this.styles == null) {
            this.styles = new ArrayList<String>();
        }
        if (style != null) {
            this.styles.addAll(Arrays.asList(style));
        }
        return this;
    }

    public SlideTabBuilder fixedContentSize(int pixel) {
        this.pixel = pixel;
        return this;
    }

    public SlideTabBuilder autoCollapseSlider(boolean autoCollapseSlider) {
        this.autoCollapseSlider = autoCollapseSlider;
        return this;
    }

    public SlideTabBuilder zIndex(int zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public SlideTabBuilder scheduleStrategy(ScheduleStrategy scheduleStrategy) {
        this.scheduleStrategy = scheduleStrategy;
        return this;
    }

    public SlideTab build() {
        return new SlideTab(this);
    }
}

