/*
 * Decompiled with CFR 0.152.
 */
package com.lipisak.vaadin.slidetab;

import com.lipisak.vaadin.slidetab.DefaultScheduleStrategy;
import com.lipisak.vaadin.slidetab.ScheduleStrategy;
import com.lipisak.vaadin.slidetab.SlideMode;
import com.lipisak.vaadin.slidetab.SlideTabBuilder;
import com.lipisak.vaadin.slidetab.SlideTabPosition;
import com.lipisak.vaadin.slidetab.SlideToggleEvent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.template.Id;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.TimerTask;

@Tag(value="slide-tab")
@JsModule(value="./src/slide-tab.js")
public class SlideTab
extends LitTemplate
implements HasComponents,
HasSize,
HasStyle {
    @Id(value="tab")
    private Div tabComponent;
    @Id(value="content")
    private Div contentComponent;
    private Component expandComponent;
    private Component collapseComponent;
    private final SlideMode slideMode;
    private final ScheduleStrategy scheduleStrategy;
    private boolean expanded;
    private boolean autoCollapsing;
    private boolean toggleEnabled;
    private int pixelSize;
    private int animationDuration;
    private int zIndex;

    public SlideTab(SlideTabBuilder builder) {
        this.add(new Component[]{builder.content});
        this.tabComponent.setHeight(builder.tabSize + "px");
        this.slideMode = builder.mode;
        this.addClassName(builder.mode.toString().toLowerCase());
        this.setAnimationDuration(builder.animationDuration);
        this.setFixedContentSize(builder.pixel);
        this.setZIndex(builder.zIndex);
        this.setCaption(builder.caption);
        this.setTabPosition(builder.tabPosition);
        this.setClosingOnOutsideClick(builder.autoCollapseSlider);
        this.setTabVisible(builder.tabVisible);
        this.setToggleEnabled(true);
        this.scheduleStrategy = builder.scheduleStrategy != null ? builder.scheduleStrategy : new DefaultScheduleStrategy();
        if (builder.listeners != null) {
            builder.listeners.forEach(this::addToggleListener);
        }
        if (builder.styles != null) {
            for (String style : builder.styles) {
                this.addClassName(style);
            }
        }
    }

    public void expand() {
        this.expand(false);
    }

    private void expand(boolean fromClient) {
        if (!this.expanded && this.toggleEnabled) {
            this.expanded = true;
            this.doExpand();
            this.fireEvent(new SlideToggleEvent(this, fromClient, true));
        }
    }

    private void doExpand() {
        this.getElement().callJsFunction("expand", new Serializable[]{Integer.valueOf(this.pixelSize), Boolean.valueOf(this.slideMode.isVertical())});
    }

    public void collapse() {
        this.collapse(false);
    }

    private void collapse(boolean fromClient) {
        if (this.expanded && this.toggleEnabled) {
            this.expanded = false;
            this.getElement().callJsFunction("collapse", new Serializable[]{Boolean.valueOf(this.slideMode.isVertical())});
            this.fireEvent(new SlideToggleEvent(this, fromClient, false));
        }
    }

    @ClientCallable
    public void toggle() {
        if (this.isExpanded()) {
            this.collapse(true);
        } else {
            this.expand(true);
        }
    }

    @ClientCallable
    public void onOutsideClicked() {
        if (this.autoCollapsing && this.expanded) {
            this.collapse(true);
        }
    }

    public void setCaption(String caption) {
        this.getElement().setProperty("caption", caption);
    }

    public String getCaption() {
        return this.getElement().getProperty("caption", null);
    }

    public void setExpandComponent(Component component) {
        if (this.expandComponent != null) {
            this.remove(new Component[]{this.expandComponent});
        }
        this.expandComponent = component;
        this.expandComponent.getElement().setAttribute("slot", "expand");
        this.add(new Component[]{this.expandComponent});
    }

    public Component getExpandComponent() {
        return this.expandComponent;
    }

    public void setCollapseComponent(Component component) {
        if (this.collapseComponent != null) {
            this.remove(new Component[]{this.collapseComponent});
        }
        this.collapseComponent = component;
        this.collapseComponent.getElement().setAttribute("slot", "collapse");
        this.add(new Component[]{this.collapseComponent});
    }

    public Component getCollapseComponent() {
        return this.collapseComponent;
    }

    public void setTabPosition(SlideTabPosition tabPosition) {
        Arrays.stream(SlideTabPosition.values()).forEach(value -> this.setClassName(value.name().toLowerCase(), value == tabPosition));
    }

    public void setClosingOnOutsideClick(boolean autoCollapsing) {
        this.autoCollapsing = autoCollapsing;
        this.setElementClosingOnOutsideClick();
    }

    private void setElementClosingOnOutsideClick() {
        this.getElement().callJsFunction("setClosingOnOutsideClick", new Serializable[]{Boolean.valueOf(this.autoCollapsing)});
    }

    public boolean isClosingOnOutsideClick() {
        return this.autoCollapsing;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        if (this.animationDuration != animationDuration) {
            this.animationDuration = animationDuration;
            this.contentComponent.getStyle().set("transition", String.format("height %dms, width %dms", animationDuration, animationDuration));
        }
    }

    public void setFixedContentSize(int pixelHeight) {
        this.pixelSize = pixelHeight;
    }

    public int getFixedContentSize() {
        return this.pixelSize;
    }

    public void setZIndex(int zIndex) {
        this.zIndex = zIndex;
        this.getStyle().set("z-index", String.valueOf(zIndex));
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setTabVisible(boolean visible) {
        this.tabComponent.getStyle().set("display", visible ? "flex" : "none");
    }

    public boolean isTabVisible() {
        return this.tabComponent.isVisible();
    }

    public void setExpanded(boolean expanded, boolean animated) {
        if (this.expanded != expanded) {
            this.setAnimationDuration(animated ? this.animationDuration : 0);
            if (expanded) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void scheduleExpand(boolean value, boolean animated, int delayMillis) {
        this.scheduleStrategy.schedule(new TabTask((Command & Serializable)() -> this.setExpanded(value, animated)), delayMillis);
    }

    public void scheduleToggle(int delayMillis) {
        this.scheduleStrategy.schedule(new TabTask(this::toggle), delayMillis);
    }

    public void scheduleCollapse(int delayMillis) {
        this.scheduleStrategy.schedule(new TabTask(this::collapse), delayMillis);
    }

    public void scheduleExpand(int delayMillis) {
        this.scheduleStrategy.schedule(new TabTask(this::expand), delayMillis);
    }

    public Registration addToggleListener(ComponentEventListener<SlideToggleEvent> listener) {
        return this.addListener(SlideToggleEvent.class, listener);
    }

    public void setToggleEnabled(boolean enabled) {
        this.toggleEnabled = enabled;
    }

    public boolean isToggleEnabled() {
        return this.toggleEnabled;
    }

    public void onAttach(AttachEvent attachEvent) {
        if (this.expanded) {
            this.doExpand();
        }
        this.setElementClosingOnOutsideClick();
    }

    public class TabTask
    extends TimerTask {
        private final Command command;

        private TabTask(Command command) {
            this.command = command;
        }

        @Override
        public void run() {
            SlideTab.this.getUI().ifPresent(ui -> ui.access(this.command));
        }
    }
}

