/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.DateSelectedEvent;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.flowingcode.vaadin.jsonmigration.JsonSerializer;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractCalendarComponent<COMPONENT extends Component>
extends Component {
    private DatePicker.DatePickerI18n i18n;

    protected void onAttach(AttachEvent attachEvent) {
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
        this.refreshAll();
    }

    public void setI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.getUI().ifPresent(ui -> this.setI18nWithJS());
    }

    private void setI18nWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
            JsonMigration.executeJs((Element)this.getElement(), (String)"this.i18n = Object.assign({}, this.i18n, $0);", (Serializable[])new Serializable[]{i18nObject});
        });
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public abstract void refreshAll();

    public Registration addDateSelectedListener(ComponentEventListener<DateSelectedEvent<? super COMPONENT>> listener) {
        return ComponentUtil.addListener((Component)this, DateSelectedEvent.class, listener);
    }
}

