/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.AbstractCalendarComponent;
import com.flowingcode.addons.ycalendar.MonthCalendar;
import com.flowingcode.addons.ycalendar.YearChangedEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Year;
import java.util.Optional;
import java.util.stream.IntStream;

@Tag(value="fc-year-calendar")
@JsModule(value="./fc-year-calendar/fc-year-calendar.js")
@Uses(value=MonthCalendar.class)
public class YearCalendar
extends AbstractCalendarComponent<YearCalendar>
implements HasSize,
HasTheme {
    private ValueProvider<LocalDate, String> classNameGenerator;

    public void setYear(int year) {
        int currentYear = this.getYear();
        this.getElement().setProperty("year", (double)year);
        if (currentYear != year) {
            this.refreshAll();
        }
    }

    public int getYear() {
        return this.getElement().getProperty("year", Year.now().getValue());
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setAttribute("readonly", readOnly);
    }

    public void setClassNameGenerator(ValueProvider<LocalDate, String> classNameGenerator) {
        this.classNameGenerator = classNameGenerator;
        this.refreshAll();
    }

    @Override
    public void refreshAll() {
        Year year = Year.of(this.getYear());
        IntStream.rangeClosed(1, year.length()).mapToObj(year::atDay).forEach(this::refreshItem);
    }

    public void refreshItem(LocalDate date) {
        if (date.getYear() == this.getYear()) {
            String className = Optional.ofNullable(this.classNameGenerator).map(g -> (String)g.apply((Object)date)).orElse(null);
            this.getElement().executeJs("setTimeout(()=>{this._setStyleForDay($0,$1,$2);})", new Serializable[]{Integer.valueOf(date.getDayOfMonth()), Integer.valueOf(date.getMonthValue()), className});
        }
    }

    public Registration addYearChangedListener(ComponentEventListener<YearChangedEvent<YearCalendar>> listener) {
        return ComponentUtil.addListener((Component)this, YearChangedEvent.class, listener);
    }
}

