/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Optional;

@Tag(value="fc-date-picker")
@JsModule(value="./fc-date-picker/fc-date-picker.js")
public class ExtendedDatePicker
extends DatePicker {
    private ValueProvider<LocalDate, String> classNameGenerator;

    public ExtendedDatePicker() {
    }

    public ExtendedDatePicker(LocalDate initialDate) {
        this();
        this.setValue(initialDate);
    }

    public void setClassNameGenerator(ValueProvider<LocalDate, String> classNameGenerator) {
        this.classNameGenerator = classNameGenerator;
        this.refreshAll();
    }

    public void refreshAll() {
        this.getElement().executeJs("this.refreshAll()", new Serializable[0]);
    }

    @ClientCallable
    private JsonObject fetchStyles(String minStr, String maxStr) {
        JsonObject result = Json.createObject();
        YearMonth min = YearMonth.parse(minStr);
        YearMonth max = YearMonth.parse(maxStr);
        YearMonth m = min;
        while (m.compareTo(max) <= 0) {
            String key = m.toString();
            this.getStyles(m).ifPresent(styles -> result.put(key, (JsonValue)styles));
            m = m.plusMonths(1L);
        }
        return result;
    }

    private Optional<JsonObject> getStyles(YearMonth yearMonth) {
        JsonObject monthStyles = Json.createObject();
        int n = yearMonth.lengthOfMonth();
        for (int i = 1; i <= n; ++i) {
            LocalDate date = yearMonth.atDay(i);
            Optional.ofNullable(this.classNameGenerator).map(g -> (String)g.apply((Object)date)).ifPresent(className -> monthStyles.put(Integer.toString(date.getDayOfMonth()), className));
        }
        return monthStyles.keys().length > 0 ? Optional.of(monthStyles) : Optional.empty();
    }
}

