/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.ChatMessage;
import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.component.react.ReactAdapterComponent;
import com.vaadin.flow.component.virtuallist.VirtualList;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@NpmPackage.Container(value={@NpmPackage(value="react-draggable", version="4.4.6"), @NpmPackage(value="@mui/material", version="7.1.2"), @NpmPackage(value="@mui/icons-material", version="6.1.0"), @NpmPackage(value="@emotion/react", version="11.14.0"), @NpmPackage(value="@emotion/styled", version="11.14.0")})
@JsModule.Container(value={@JsModule(value="./react/animated-fab.tsx"), @JsModule(value="./fcChatAssistantConnector.js")})
@Tag(value="animated-fab")
@CssImport(value="./styles/chat-assistant-styles.css")
public class ChatAssistant<T extends Message>
extends ReactAdapterComponent
implements ClickNotifier<ChatAssistant<T>> {
    private static final String CHAT_HEADER_CLASS_NAME = "chat-header";
    private Component headerComponent;
    private VerticalLayout container;
    private Component footerContainer;
    private VirtualList<T> content = new VirtualList();
    private Popover chatWindow;
    private List<T> messages;
    private MessageInput messageInput;
    private Span whoIsTyping;
    private boolean minimized = true;
    private Registration defaultSubmitListenerRegistration;
    private SerializableSupplier<Avatar> avatarProvider = (SerializableSupplier & Serializable)() -> new Avatar("Chat Assistant");
    private Avatar avatar;

    public ChatAssistant() {
        this(new ArrayList(), false);
    }

    public ChatAssistant(boolean markdownEnabled) {
        this(new ArrayList(), markdownEnabled);
    }

    public ChatAssistant(List<T> messages, boolean markdownEnabled) {
        this.messages = messages;
        this.initializeHeader();
        this.initializeFooter();
        this.initializeContent(markdownEnabled);
        this.initializeChatWindow();
        this.initializeAvatar();
    }

    private void initializeHeader() {
        Icon minimize = VaadinIcon.CLOSE.create();
        minimize.addClickListener((ComponentEventListener & Serializable)ev -> this.setMinimized(!this.minimized));
        Span title = new Span("Chat Assistant");
        title.setWidthFull();
        HorizontalLayout header = new HorizontalLayout(new Component[]{title, minimize});
        header.setWidthFull();
        this.headerComponent = header;
    }

    private void initializeFooter() {
        this.messageInput = new MessageInput();
        this.messageInput.setWidthFull();
        this.messageInput.setMaxHeight("80px");
        this.messageInput.getStyle().set("padding", "0");
        this.defaultSubmitListenerRegistration = this.messageInput.addSubmitListener((ComponentEventListener & Serializable)se -> this.sendMessage(((Message.MessageBuilder)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().messageTime(LocalDateTime.now())).name("User")).content(se.getValue())).build()));
        this.whoIsTyping = new Span();
        this.whoIsTyping.setClassName("chat-assistant-who-is-typing");
        this.whoIsTyping.setVisible(false);
        VerticalLayout footer = new VerticalLayout(new Component[]{this.whoIsTyping, this.messageInput});
        footer.setWidthFull();
        footer.setSpacing(false);
        footer.setMargin(false);
        footer.setPadding(false);
        this.footerContainer = footer;
    }

    private void initializeContent(boolean markdownEnabled) {
        this.content.setRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)message -> new ChatMessage<Message>((Message)message, markdownEnabled), (SerializableBiFunction & Serializable)(component, message) -> {
            ((ChatMessage)((Object)((Object)component))).setMessage(message);
            return component;
        }));
        this.content.setItems(this.messages);
        this.content.setSizeFull();
        this.container = new VerticalLayout(new Component[]{this.headerComponent, this.content, this.footerContainer});
        this.container.setClassName("chat-assistant-container-vertical-layout");
        this.container.setPadding(false);
        this.container.setMargin(false);
        this.container.setSpacing(false);
        this.container.setSizeFull();
        this.container.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.container.setFlexGrow(1.0, new HasElement[]{this.content});
    }

    private void initializeChatWindow() {
        VerticalLayout resizableVL = new VerticalLayout();
        resizableVL.setClassName("chat-assistant-resizable-vertical-layout");
        resizableVL.add(new Component[]{this.container});
        this.chatWindow = new Popover();
        this.chatWindow.add(new Component[]{resizableVL});
        this.chatWindow.setOpenOnClick(false);
        this.chatWindow.setCloseOnOutsideClick(false);
        this.chatWindow.addOpenedChangeListener((ComponentEventListener & Serializable)ev -> {
            this.minimized = !ev.isOpened();
        });
        this.chatWindow.addAttachListener((ComponentEventListener & Serializable)e -> e.getUI().getPage().executeJs("window.Vaadin.Flow.fcChatAssistantConnector.observePopoverResize($0)", new Serializable[]{this.chatWindow.getElement()}));
        this.getElement().addEventListener("avatar-clicked", (DomEventListener & Serializable)ev -> {
            if (this.minimized) {
                this.chatWindow.open();
            } else {
                this.chatWindow.close();
            }
        });
    }

    private void initializeAvatar() {
        if (this.avatar != null) {
            this.avatar.removeFromParent();
        }
        this.avatar = (Avatar)this.avatarProvider.get();
        this.getElement().appendChild(new Element[]{this.avatar.getElement()});
        this.addAttachListener((ComponentEventListener & Serializable)ev -> JsonMigration.executeJs((Element)this.getElement(), (String)"return;", (Serializable[])new Serializable[0]).then((SerializableConsumer & Serializable)ev2 -> JsonMigration.executeJs((Element)this.getElement(), (String)"this.childNodes[1].childNodes[0].childNodes[0].appendChild($0)", (Serializable[])new Serializable[]{this.avatar.getElement()}).then((SerializableConsumer & Serializable)ev3 -> {
            this.chatWindow.setTarget((Component)this.avatar);
            this.avatar.setSizeFull();
        })));
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.content.setDataProvider(dataProvider);
    }

    public void setWhoIsTyping(String whoIsTyping) {
        this.whoIsTyping.setText(whoIsTyping);
        this.whoIsTyping.setVisible(true);
    }

    public String getWhoIsTyping() {
        return this.whoIsTyping.getText();
    }

    public void clearWhoIsTyping() {
        this.whoIsTyping.setText(null);
        this.whoIsTyping.setVisible(false);
    }

    public Registration setSubmitListener(ComponentEventListener<MessageInput.SubmitEvent> listener) {
        this.defaultSubmitListenerRegistration.remove();
        return this.messageInput.addSubmitListener(listener);
    }

    private void refreshContent() {
        this.content.getDataProvider().refreshAll();
        this.content.scrollToEnd();
    }

    public void sendMessage(T message) {
        this.messages.add(message);
        this.content.getDataProvider().refreshAll();
        this.content.scrollToEnd();
    }

    public void updateMessage(T message) {
        this.content.getDataProvider().refreshItem(message);
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized != minimized) {
            this.minimized = minimized;
            if (!minimized) {
                this.refreshContent();
            }
        }
        if (minimized && this.chatWindow.isOpened()) {
            this.chatWindow.close();
        } else if (!minimized && !this.chatWindow.isOpened()) {
            this.chatWindow.open();
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setHeaderComponent(Component component) {
        if (this.headerComponent != null) {
            this.container.remove(new Component[]{this.headerComponent});
        }
        component.addClassName(CHAT_HEADER_CLASS_NAME);
        this.headerComponent = component;
        this.container.addComponentAsFirst(this.headerComponent);
    }

    public Component getHeaderComponent() {
        return this.headerComponent;
    }

    public void setFooterComponent(Component component) {
        Objects.requireNonNull(component, "Component cannot not be null");
        this.container.remove(new Component[]{this.footerContainer});
        this.footerContainer = component;
        this.container.add(new Component[]{this.footerContainer});
    }

    public Component getFooterComponent() {
        return this.footerContainer;
    }

    public void scrollToIndex(int position) {
        this.content.scrollToIndex(position);
    }

    public void scrollToStart() {
        this.content.scrollToStart();
    }

    public void scrollToEnd() {
        this.content.scrollToEnd();
    }

    public void setMessagesRenderer(Renderer<T> renderer) {
        Objects.requireNonNull(renderer, "Renderer cannot not be null");
        this.content.setRenderer(renderer);
    }

    public void setAvatarProvider(SerializableSupplier<Avatar> avatarProvider) {
        this.avatarProvider = avatarProvider;
        this.initializeAvatar();
    }

    public int getUnreadMessages() {
        Integer unreadMessages = (Integer)this.getState("unreadMessages", Integer.class);
        return unreadMessages == null ? 0 : unreadMessages;
    }

    public void setUnreadMessages(int unreadMessages) {
        this.setState("unreadMessages", unreadMessages);
    }
}

