/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.component.gridpro.EditColumnConfigurer;
import com.vaadin.flow.component.gridpro.EditorType;
import com.vaadin.flow.component.gridpro.GridPro;
import com.vaadin.flow.component.gridpro.GridProVariant;
import com.vaadin.flow.component.gridpro.ItemUpdater;
import com.vaadin.flow.component.treegrid.TreeGridPro;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JacksonSerializer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-grid-pro")
@NpmPackage(value="@vaadin/grid-pro", version="25.0.0")
@JsModule.Container(value={@JsModule(value="@vaadin/grid-pro/src/vaadin-grid-pro.js"), @JsModule(value="@vaadin/grid-pro/src/vaadin-grid-pro-edit-column.js"), @JsModule(value="./gridProConnector.js")})
public class AbstractGridPro<E>
extends Grid<E> {
    private Map<String, Grid.Column<E>> idToColumnMap = new HashMap<String, Grid.Column<E>>();

    public AbstractGridPro(Class<E> beanType) {
        super(beanType);
        this.setup();
    }

    public AbstractGridPro() {
        this.setup();
    }

    public AbstractGridPro(int pageSize) {
        super(pageSize);
        this.setup();
    }

    public <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<E, U>> AbstractGridPro(int pageSize, TreeGridPro.TreeDataCommunicatorBuilder<E> dataCommunicatorBuilder) {
        super(pageSize, dataCommunicatorBuilder);
        this.setup();
    }

    protected <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<E, U>> AbstractGridPro(Class<E> beanType, TreeGridPro.TreeDataCommunicatorBuilder<E> dataCommunicatorBuilder) {
        super(beanType, dataCommunicatorBuilder);
    }

    protected <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<E, U>> AbstractGridPro(Class<E> beanType, TreeGridPro.TreeDataCommunicatorBuilder<E> dataCommunicatorBuilder, boolean autoCreateColumns) {
        this(50, dataCommunicatorBuilder);
        Objects.requireNonNull(dataCommunicatorBuilder, "Data communicator builder can't be null");
        this.configureBeanType(beanType, autoCreateColumns);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getElement().setProperty("_editingDisabled", !enabled);
    }

    private void setup() {
        this.addItemPropertyChangedListener((ComponentEventListener & Serializable)e -> {
            if (e.getItem() == null) {
                return;
            }
            EditColumn column = (EditColumn)this.idToColumnMap.get(e.getPath());
            Object idBeforeUpdate = this.getItemId(e.getItem());
            if (column.getEditorType().equals("custom")) {
                column.getItemUpdater().accept(e.getItem(), null);
            } else {
                column.getItemUpdater().accept(e.getItem(), (Object)e.getSourceItem().get(e.getPath()).asString());
            }
            if (!column.isManualRefresh()) {
                Object idAfterUpdate = this.getItemId(e.getItem());
                if (!Objects.equals(idBeforeUpdate, idAfterUpdate)) {
                    LoggerFactory.getLogger(GridPro.class).warn("An item updater modified the data provider ID of the edited item, which is not allowed. This can happen with classes that implement hashCode using fields that can be edited. Either change the hashCode implementation so that it does not rely on editable fields, or override DataProvider.getId() to generate a stable ID that does not change when editing fields.");
                }
                this.getDataProvider().refreshItem(e.getItem());
            }
        });
        this.addCellEditStartedListener((ComponentEventListener & Serializable)e -> {
            EditColumn column = (EditColumn)this.idToColumnMap.get(e.getPath());
            if (column.getEditorType().equals("custom")) {
                column.getEditorField().setValue(column.getValueProvider().apply(e.getItem()));
                UI.getCurrent().getPage().executeJs("window.Vaadin.Flow.gridProConnector.selectAll($0)", new Object[]{column.getEditorField().getElement()});
            }
        });
    }

    private Object getItemId(E item) {
        if (item == null) {
            return null;
        }
        Object itemId = this.getDataProvider().getId(item);
        if (Objects.equals(item, itemId)) {
            itemId = item.hashCode();
        }
        return itemId;
    }

    public EditColumnConfigurer<E> addEditColumn(ValueProvider<E, ?> valueProvider) {
        EditColumn column = (EditColumn)this.addColumn(valueProvider, this::createEditColumn);
        return new EditColumnConfigurer<E>(column, valueProvider);
    }

    public EditColumnConfigurer<E> addEditColumn(ValueProvider<E, ?> valueProvider, Renderer<E> renderer) {
        String columnId = this.createColumnId(false);
        EditColumn column = (EditColumn)this.addColumn((Renderer)new ColumnComponentPathRenderer<E>(columnId, (ValueProvider & Serializable)value -> {
            Object item = valueProvider.apply(value);
            if (item != null) {
                return item.toString();
            }
            return "";
        }, renderer), this::createEditColumn);
        return new EditColumnConfigurer<E>(column, valueProvider);
    }

    public <V extends Comparable<? super V>> EditColumnConfigurer<E> addEditColumn(ValueProvider<E, V> valueProvider, String ... sortingProperties) {
        EditColumn column = (EditColumn)this.addColumn(valueProvider, this::createEditColumn);
        column.setComparator(valueProvider);
        column.setSortProperty(sortingProperties);
        return new EditColumnConfigurer<E>(column, valueProvider);
    }

    public EditColumnConfigurer<E> addEditColumn(String propertyName) {
        EditColumn column = (EditColumn)this.addColumn(propertyName, this::createEditColumn);
        ValueProvider & Serializable valueProvider = (ValueProvider & Serializable)item -> ((PropertyDefinition)this.getPropertySet().getProperty(propertyName).get()).getGetter().apply(item);
        return new EditColumnConfigurer(column, valueProvider);
    }

    public void setEnterNextRow(boolean enterNextRow) {
        this.getElement().setProperty("enterNextRow", enterNextRow);
    }

    @Synchronize(value={"enter-next-row-changed"})
    public boolean getEnterNextRow() {
        return this.getElement().getProperty("enterNextRow", false);
    }

    public void setSingleCellEdit(boolean singleCellEdit) {
        this.getElement().setProperty("singleCellEdit", singleCellEdit);
    }

    @Synchronize(value={"single-cell-edit-changed"})
    public boolean getSingleCellEdit() {
        return this.getElement().getProperty("singleCellEdit", false);
    }

    public void setEditOnClick(boolean editOnClick) {
        this.getElement().setProperty("editOnClick", editOnClick);
    }

    @Synchronize(value={"edit-on-click-changed"})
    public boolean getEditOnClick() {
        return this.getElement().getProperty("editOnClick", false);
    }

    protected EditColumn<E> createEditColumn(Renderer<E> renderer, String columnId) {
        EditColumn<E> column = new EditColumn<E>(this, columnId, renderer);
        this.idToColumnMap.put(columnId, column);
        return column;
    }

    public Registration addCellEditStartedListener(ComponentEventListener<CellEditStartedEvent<E>> listener) {
        return ComponentUtil.addListener((Component)this, CellEditStartedEvent.class, listener);
    }

    public Registration addItemPropertyChangedListener(ComponentEventListener<ItemPropertyChangedEvent<E>> listener) {
        return ComponentUtil.addListener((Component)this, ItemPropertyChangedEvent.class, listener);
    }

    public void addThemeVariants(GridProVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(GridProVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(GridProVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(GridProVariant::getVariantName).collect(Collectors.toList()));
    }

    @Tag(value="vaadin-grid-pro-edit-column")
    public static class EditColumn<T>
    extends Grid.Column<T> {
        private ItemUpdater<T, String> itemUpdater;
        private HasValueAndElement editorField;
        private ValueProvider<T, ?> valueProvider;
        private SerializablePredicate<T> cellEditableProvider;
        private boolean manualRefresh = false;

        public EditColumn(AbstractGridPro<T> grid, String columnId, Renderer<T> renderer) {
            super(grid, columnId, renderer);
        }

        protected EditColumn<T> setItemUpdater(ItemUpdater<T, String> itemUpdater) {
            this.itemUpdater = itemUpdater;
            return this;
        }

        protected ItemUpdater<T, String> getItemUpdater() {
            return this.itemUpdater;
        }

        protected HasValueAndElement getEditorField() {
            return this.editorField;
        }

        protected void setEditorField(HasValueAndElement editorField) {
            this.editorField = editorField;
        }

        protected EditColumn<T> setEditorType(EditorType type) {
            this.getElement().setProperty("editorType", type == null ? "text" : type.getTypeName());
            return this;
        }

        @Synchronize(value={"editor-type-changed"})
        protected String getEditorType() {
            return this.getElement().getProperty("editorType", "text");
        }

        protected EditColumn<T> setOptions(List<String> options) {
            this.getElement().setPropertyJson("editorOptions", (BaseJsonNode)JacksonSerializer.toJson(options));
            return this;
        }

        @Synchronize(value={"editor-options-changed"})
        protected List<String> getOptions() {
            return JacksonSerializer.toObjects(String.class, (ArrayNode)((ArrayNode)this.getElement().getPropertyRaw("editorOptions")));
        }

        public ValueProvider<T, ?> getValueProvider() {
            return this.valueProvider;
        }

        public void setValueProvider(ValueProvider<T, ?> valueProvider) {
            this.valueProvider = valueProvider;
        }

        boolean isManualRefresh() {
            return this.manualRefresh;
        }

        void setManualRefresh(boolean manualRefresh) {
            this.manualRefresh = manualRefresh;
        }

        void setCellEditableProvider(SerializablePredicate<T> cellEditableProvider) {
            this.cellEditableProvider = cellEditableProvider;
        }

        protected String getInternalId() {
            return super.getInternalId();
        }
    }

    class ColumnComponentPathRenderer<SOURCE>
    extends ColumnPathRenderer<SOURCE> {
        private Renderer<SOURCE> representationRenderer;

        public ColumnComponentPathRenderer(String property, ValueProvider<SOURCE, ?> provider, Renderer<SOURCE> renderer) {
            super(property, provider);
            this.representationRenderer = renderer;
        }

        public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
            final Rendering columnPathRendering = super.render(container, keyMapper, rendererName);
            final Rendering representationRendering = this.representationRenderer.render(container, keyMapper);
            return new Rendering<SOURCE>(){

                public Optional<DataGenerator<SOURCE>> getDataGenerator() {
                    CompositeDataGenerator compositeDataGenerator = new CompositeDataGenerator();
                    compositeDataGenerator.addDataGenerator((DataGenerator)representationRendering.getDataGenerator().get());
                    compositeDataGenerator.addDataGenerator((DataGenerator)columnPathRendering.getDataGenerator().get());
                    return Optional.of(compositeDataGenerator);
                }
            };
        }
    }

    @DomEvent(value="cell-edit-started")
    public static class CellEditStartedEvent<E>
    extends ComponentEvent<TreeGridPro<E>> {
        private E item;
        private String path;

        public CellEditStartedEvent(TreeGridPro<E> source, boolean fromClient, @EventData(value="event.detail.item") ObjectNode item, @EventData(value="event.detail.path") String path) {
            super(source, fromClient);
            this.item = source.getDataCommunicator().getKeyMapper().get(item.get("key").asString());
            this.path = path;
        }

        public E getItem() {
            return this.item;
        }

        private String getPath() {
            return this.path;
        }
    }

    @DomEvent(value="item-property-changed")
    public static class ItemPropertyChangedEvent<E>
    extends ComponentEvent<TreeGridPro<E>> {
        private E item;
        private ObjectNode sourceItem;
        private String path;

        public ItemPropertyChangedEvent(TreeGridPro<E> source, boolean fromClient, @EventData(value="event.detail.item") ObjectNode item, @EventData(value="event.detail.path") String path) {
            super(source, fromClient);
            this.sourceItem = item;
            this.item = source.getDataCommunicator().getKeyMapper().get(item.get("key").asString());
            this.path = path;
        }

        public E getItem() {
            return this.item;
        }

        private ObjectNode getSourceItem() {
            return this.sourceItem;
        }

        private String getPath() {
            return this.path;
        }
    }
}

