/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.toolbarlayout;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.vaadin.addons.componentfactory.toolbarlayout.ToolbarLayoutVariant;

@Tag(value="vcf-toolbar-layout")
@NpmPackage(value="@vaadin-component-factory/vcf-toolbar-layout", version="2.0.0")
@JsModule(value="@vaadin-component-factory/vcf-toolbar-layout/dist/src/vcf-toolbar-layout.js")
@CssImport(value="./styles/toolbar-layout-styles.css")
public class ToolbarLayout
extends Component
implements HasOrderedComponents,
HasSize,
HasStyle,
HasThemeVariant<ToolbarLayoutVariant> {
    private static final String OVERFLOW_BUTTON_SLOT = "overflow-button";
    private boolean isOpenHover = false;
    private boolean isDropdownIndicatorShown = true;

    public boolean isDropdownIndicatorShown() {
        return this.isDropdownIndicatorShown;
    }

    public void setDropdownIndicatorShown(boolean isDropdownIndicatorShown) {
        this.isDropdownIndicatorShown = isDropdownIndicatorShown;
        this.findAllMenuBars().forEach(menuBar -> {
            if (isDropdownIndicatorShown) {
                menuBar.addThemeNames(new String[]{"dropdown-indicators"});
            } else {
                menuBar.removeThemeNames(new String[]{"dropdown-indicators"});
            }
        });
    }

    public int getUpdateDebounceDelay() {
        return this.getElement().getProperty("updateDebounceDelay", 0);
    }

    public void setUpdateDebounceDelay(int delay) {
        this.getElement().setProperty("updateDebounceDelay", (double)delay);
    }

    public MenuItem addItem(String text, Component icon) {
        MenuBar menuBar = this.createMenuBar();
        this.add(new Component[]{menuBar});
        Button button = new Button(text, icon);
        button.addThemeNames(new String[]{"tertiary", "tertiary-inline"});
        return menuBar.addItem((Component)button);
    }

    public MenuItem addItem(String text) {
        MenuBar menuBar = this.createMenuBar();
        this.add(new Component[]{menuBar});
        return menuBar.addItem(text);
    }

    public void addItem(Component component) {
        this.add(new Component[]{component});
    }

    public MenuItem addItem(String text, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        MenuItem item = this.addItem(text);
        item.addClickListener(clickListener);
        return item;
    }

    public <T extends Component> void addItem(T component, ComponentEventListener<ClickEvent<T>> clickListener) {
        if (component instanceof ClickNotifier) {
            ClickNotifier cn = (ClickNotifier)component;
            cn.addClickListener(clickListener);
        } else {
            component.getElement().addEventListener("click", (DomEventListener & Serializable)e -> clickListener.onComponentEvent((ComponentEvent)new ClickEvent(component)));
        }
        this.add(new Component[]{component});
    }

    public MenuItem addItem(String text, String tooltipText) {
        MenuItem item = this.addItem(text);
        this.setMenuItemTooltipText(item, tooltipText);
        return item;
    }

    public MenuItem addItem(String text, String tooltipText, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        MenuItem item = this.addItem(text, clickListener);
        this.setMenuItemTooltipText(item, tooltipText);
        return item;
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.isOpenHover = openOnHover;
        this.findAllMenuBars().forEach(menuBar -> menuBar.setOpenOnHover(openOnHover));
    }

    public boolean isOpenOnHover() {
        return this.isOpenHover;
    }

    public void setReverseCollapseOrder(boolean reverseCollapseOrder) {
        this.getElement().setProperty("reverseCollapse", reverseCollapseOrder);
    }

    public boolean isReverseCollapseOrder() {
        return this.getElement().getProperty("reverseCollapse", false);
    }

    public void setOverflowButton(Button overflowButton) {
        this.getChildren().filter(c -> OVERFLOW_BUTTON_SLOT.equals(c.getElement().getAttribute("slot"))).forEach(xva$0 -> this.remove(new Component[]{xva$0}));
        if (overflowButton != null) {
            overflowButton.getElement().setAttribute("slot", OVERFLOW_BUTTON_SLOT);
            this.add(new Component[]{overflowButton});
        }
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.setOpenOnHover(this.isOpenHover);
        menuBar.addThemeNames(new String[]{"dropdown-indicators"});
        return menuBar;
    }

    private List<MenuBar> findAllMenuBars() {
        return this.getChildren().filter(c -> c instanceof MenuBar).map(MenuBar.class::cast).collect(Collectors.toList());
    }

    private void setMenuItemTooltipText(MenuItem item, String tooltipText) {
        this.findMenuBarParent(item).ifPresentOrElse(menuBar -> menuBar.setTooltipText(item, tooltipText), () -> {
            throw new IllegalStateException("MenuItem is not a child of a MenuBar");
        });
    }

    private Optional<MenuBar> findMenuBarParent(MenuItem menuItem) {
        Object parent = null;
        MenuItem currentComponent = menuItem;
        while (!(currentComponent instanceof MenuBar) && currentComponent.getParent().isPresent()) {
            currentComponent = (Component)currentComponent.getParent().get();
        }
        if (currentComponent instanceof MenuBar) {
            return Optional.of((MenuBar)currentComponent);
        }
        return Optional.empty();
    }
}

