/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Set;
import java.util.stream.Collectors;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.RecurrenceRule;

public class RecurrenceEvaluator {
    public static boolean occursInRange(RecurrenceRule rule, LocalDate startDate, LocalDate rangeStart, LocalDate rangeEnd) {
        if (rule == null || rule.getFreq() == null) {
            return false;
        }
        int interval = rule.getInterval() != null ? rule.getInterval() : 1;
        Integer count = rule.getCount();
        LocalDate until = rule.getUntil() != null ? rule.getUntil().getDate() : null;
        Set byDays = rule.getByDay() != null ? rule.getByDay().stream().map(RecurrenceEvaluator::toDayOfWeek).collect(Collectors.toSet()) : Set.of();
        Set byMonthDays = rule.getByMonthDay() != null ? Set.copyOf(rule.getByMonthDay()) : Set.of();
        LocalDate current = startDate;
        block12: for (int occurrences = 0; !(count != null && occurrences >= count || until != null && current.isAfter(until)); ++occurrences) {
            boolean valid;
            switch (rule.getFreq()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DAILY: {
                    boolean bl = true;
                    break;
                }
                case WEEKLY: {
                    boolean bl;
                    if (byDays.isEmpty() || byDays.contains(current.getDayOfWeek())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case MONTHLY: {
                    boolean bl;
                    if (byMonthDays.isEmpty() || byMonthDays.contains(current.getDayOfMonth())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case YEARLY: {
                    boolean bl = valid = true;
                }
            }
            if (valid && !current.isBefore(rangeStart) && current.isBefore(rangeEnd)) {
                return true;
            }
            switch (rule.getFreq()) {
                case DAILY: {
                    current = current.plusDays(interval);
                    continue block12;
                }
                case WEEKLY: {
                    current = current.plusWeeks(interval);
                    continue block12;
                }
                case MONTHLY: {
                    current = current.plusMonths(interval);
                    continue block12;
                }
                case YEARLY: {
                    current = current.plusYears(interval);
                }
            }
        }
        return false;
    }

    private static DayOfWeek toDayOfWeek(RecurrenceRule.Day day) {
        return switch (day) {
            default -> throw new IncompatibleClassChangeError();
            case RecurrenceRule.Day.MO -> DayOfWeek.MONDAY;
            case RecurrenceRule.Day.TU -> DayOfWeek.TUESDAY;
            case RecurrenceRule.Day.WE -> DayOfWeek.WEDNESDAY;
            case RecurrenceRule.Day.TH -> DayOfWeek.THURSDAY;
            case RecurrenceRule.Day.FR -> DayOfWeek.FRIDAY;
            case RecurrenceRule.Day.SA -> DayOfWeek.SATURDAY;
            case RecurrenceRule.Day.SU -> DayOfWeek.SUNDAY;
        };
    }
}

